/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.PeriodicImportConfig;
import com.facebook.presto.importer.PeriodicImportRunnable;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.facebook.presto.util.Threads;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JobStateFactory {
    private static final Logger log = Logger.get(JobStateFactory.class);
    private final ScheduledExecutorService importExecutorService;
    private final PeriodicImportRunnable.PeriodicImportRunnableFactory periodicImportRunnableFactory;

    @Inject
    public JobStateFactory(PeriodicImportConfig config, PeriodicImportRunnable.PeriodicImportRunnableFactory periodicImportRunnableFactory) {
        this.importExecutorService = new ScheduledThreadPoolExecutor(config.getThreadCount(), Threads.daemonThreadsNamed("import-%s"));
        this.periodicImportRunnableFactory = periodicImportRunnableFactory;
    }

    public JobState forImportJob(PersistentPeriodicImportJob importJob) {
        return new JobState(importJob);
    }

    @PreDestroy
    public void shutdown() {
        this.importExecutorService.shutdownNow();
    }

    public class JobState {
        private final PersistentPeriodicImportJob job;
        private final AtomicReference<ScheduledFuture<?>> futureHolder = new AtomicReference();
        private final AtomicLong lastRun = new AtomicLong(-1L);
        private final Random random = new Random();

        private JobState(PersistentPeriodicImportJob job) {
            this.job = job;
        }

        public void schedule() {
            if (this.futureHolder.get() == null) {
                long initialDelay = this.random.nextInt(50000) + 10000;
                ScheduledFuture<?> jobFuture = JobStateFactory.this.importExecutorService.scheduleAtFixedRate(JobStateFactory.this.periodicImportRunnableFactory.create(this), initialDelay, this.job.getInterval() * 1000L, TimeUnit.MILLISECONDS);
                if (!this.futureHolder.compareAndSet(null, jobFuture)) {
                    jobFuture.cancel(true);
                    return;
                }
                log.info("Scheduled Job for %d, initial delay is %dms", new Object[]{this.job.getJobId(), initialDelay});
            }
        }

        public void cancel(boolean mayInterruptIfRunning) {
            ScheduledFuture jobFuture = this.futureHolder.getAndSet(null);
            if (jobFuture != null) {
                jobFuture.cancel(mayInterruptIfRunning);
                log.info("Cancelled Job for %d", new Object[]{this.job.getJobId()});
            }
        }

        public void setLastRun(long time) {
            Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"The run time most be positive!");
            this.lastRun.set(time);
        }

        public long getLastRun() {
            return this.lastRun.get();
        }

        public PersistentPeriodicImportJob getJob() {
            return this.job;
        }
    }
}

