/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.importer;

import com.facebook.presto.importer.PeriodicImportDao;
import com.facebook.presto.importer.PeriodicImportJob;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.facebook.presto.metadata.ForMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class DatabasePeriodicImportManager
implements PeriodicImportManager {
    private static final Logger log = Logger.get(DatabasePeriodicImportManager.class);
    private static final Duration TABLE_RETRY_INTERVAL = new Duration(10.0, TimeUnit.SECONDS);
    private final PeriodicImportDao dao;
    private final NodeInfo nodeInfo;

    @Inject
    public DatabasePeriodicImportManager(@ForMetadata IDBI importDbi, NodeInfo nodeInfo) throws InterruptedException {
        Preconditions.checkNotNull((Object)importDbi, (Object)"Dbi was null!");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo was null!");
        this.dao = (PeriodicImportDao)importDbi.onDemand(PeriodicImportDao.class);
        this.createTablesWithRetry();
    }

    @Override
    public long insertJob(PeriodicImportJob job) {
        return this.dao.insertJob(job);
    }

    @Override
    public void dropJob(long jobId) {
        this.dao.dropJob(jobId);
    }

    @Override
    public void dropJobs(Predicate<PersistentPeriodicImportJob> jobPredicate) {
        for (PersistentPeriodicImportJob job : this.getJobs()) {
            if (!jobPredicate.apply((Object)job)) continue;
            this.dropJob(job.getJobId());
        }
    }

    @Override
    public long getJobCount() {
        return this.dao.getJobCount(true);
    }

    @Override
    public PersistentPeriodicImportJob getJob(long jobId) {
        return this.dao.getJob(jobId);
    }

    @Override
    public List<PersistentPeriodicImportJob> getJobs() {
        return this.dao.getJobs(true);
    }

    @Override
    public long beginRun(long jobId) {
        return this.dao.beginRun(jobId, this.nodeInfo.getNodeId());
    }

    @Override
    public void endRun(long runId, boolean result) {
        this.dao.finishRun(runId, result);
    }

    private void createTablesWithRetry() throws InterruptedException {
        while (true) {
            try {
                PeriodicImportDao.Utils.createTables(this.dao);
                return;
            }
            catch (UnableToObtainConnectionException e) {
                log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{TABLE_RETRY_INTERVAL, e.getMessage()});
                Thread.sleep(TABLE_RETRY_INTERVAL.toMillis());
                continue;
            }
            break;
        }
    }
}

