/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageStats {
    private final Distribution.DistributionSnapshot getSplitDistribution;
    private final Distribution.DistributionSnapshot scheduleTaskDistribution;
    private final Distribution.DistributionSnapshot addSplitDistribution;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final DataSize totalMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;

    @VisibleForTesting
    public StageStats() {
        this.getSplitDistribution = null;
        this.scheduleTaskDistribution = null;
        this.addSplitDistribution = null;
        this.totalTasks = 0;
        this.runningTasks = 0;
        this.completedTasks = 0;
        this.totalDrivers = 0;
        this.queuedDrivers = 0;
        this.runningDrivers = 0;
        this.completedDrivers = 0;
        this.totalMemoryReservation = null;
        this.totalScheduledTime = null;
        this.totalCpuTime = null;
        this.totalUserTime = null;
        this.totalBlockedTime = null;
        this.rawInputDataSize = null;
        this.rawInputPositions = 0L;
        this.processedInputDataSize = null;
        this.processedInputPositions = 0L;
        this.outputDataSize = null;
        this.outputPositions = 0L;
    }

    @JsonCreator
    public StageStats(@JsonProperty(value="getSplitDistribution") Distribution.DistributionSnapshot getSplitDistribution, @JsonProperty(value="scheduleTaskDistribution") Distribution.DistributionSnapshot scheduleTaskDistribution, @JsonProperty(value="addSplitDistribution") Distribution.DistributionSnapshot addSplitDistribution, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions) {
        this.getSplitDistribution = (Distribution.DistributionSnapshot)Preconditions.checkNotNull((Object)getSplitDistribution, (Object)"getSplitDistribution is null");
        this.scheduleTaskDistribution = (Distribution.DistributionSnapshot)Preconditions.checkNotNull((Object)scheduleTaskDistribution, (Object)"scheduleTaskDistribution is null");
        this.addSplitDistribution = (Distribution.DistributionSnapshot)Preconditions.checkNotNull((Object)addSplitDistribution, (Object)"addSplitDistribution is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.totalMemoryReservation = (DataSize)Preconditions.checkNotNull((Object)totalMemoryReservation, (Object)"totalMemoryReservation is null");
        this.totalScheduledTime = (Duration)Preconditions.checkNotNull((Object)totalScheduledTime, (Object)"totalScheduledTime is null");
        this.totalCpuTime = (Duration)Preconditions.checkNotNull((Object)totalCpuTime, (Object)"totalCpuTime is null");
        this.totalUserTime = (Duration)Preconditions.checkNotNull((Object)totalUserTime, (Object)"totalUserTime is null");
        this.totalBlockedTime = (Duration)Preconditions.checkNotNull((Object)totalBlockedTime, (Object)"totalBlockedTime is null");
        this.rawInputDataSize = (DataSize)Preconditions.checkNotNull((Object)rawInputDataSize, (Object)"rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = (DataSize)Preconditions.checkNotNull((Object)processedInputDataSize, (Object)"processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = (DataSize)Preconditions.checkNotNull((Object)outputDataSize, (Object)"outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getGetSplitDistribution() {
        return this.getSplitDistribution;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getScheduleTaskDistribution() {
        return this.scheduleTaskDistribution;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getAddSplitDistribution() {
        return this.addSplitDistribution;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }
}

