/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskExecution;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.SetThreadName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;

public class SqlTaskExecution
implements TaskExecution {
    private final TaskId taskId;
    private final URI location;
    private final TaskExecutor taskExecutor;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final SharedBuffer sharedBuffer;
    private final QueryMonitor queryMonitor;
    private final TaskExecutor.TaskHandle taskHandle;
    private final List<WeakReference<Driver>> drivers = new CopyOnWriteArrayList<WeakReference<Driver>>();
    private final AtomicInteger remainingDriverCount = new AtomicInteger();
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> unpartitionedSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final PlanNodeId partitionedSourceId;
    private final PipelineContext partitionedPipelineContext;
    private final DriverFactory partitionedDriverFactory;
    private final AtomicBoolean noMorePartitionedSplits = new AtomicBoolean();
    private final List<Driver> unpartitionedDrivers;
    private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);

    public static SqlTaskExecution createSqlTaskExecution(Session session, TaskId taskId, URI location, PlanFragment fragment, LocalExecutionPlanner planner, DataSize maxBufferSize, TaskExecutor taskExecutor, ExecutorService notificationExecutor, DataSize maxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, QueryMonitor queryMonitor, boolean cpuTimerEnabled) {
        SqlTaskExecution task = new SqlTaskExecution(session, taskId, location, fragment, planner, maxBufferSize, taskExecutor, maxTaskMemoryUsage, operatorPreAllocatedMemory, queryMonitor, notificationExecutor, cpuTimerEnabled);
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", taskId);){
            task.start();
            SqlTaskExecution sqlTaskExecution = task;
            return sqlTaskExecution;
        }
    }

    private SqlTaskExecution(Session session, TaskId taskId, URI location, PlanFragment fragment, LocalExecutionPlanner planner, DataSize maxBufferSize, TaskExecutor taskExecutor, DataSize maxTaskMemoryUsage, DataSize operatorPreAllocatedMemory, QueryMonitor queryMonitor, Executor notificationExecutor, boolean cpuTimerEnabled) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", taskId);){
            this.taskId = (TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
            this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
            this.taskExecutor = (TaskExecutor)Preconditions.checkNotNull((Object)taskExecutor, (Object)"driverExecutor is null");
            this.taskStateMachine = new TaskStateMachine(taskId, notificationExecutor);
            this.taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

                @Override
                public void stateChanged(TaskState taskState) {
                    if (taskState.isDone()) {
                        SqlTaskExecution.this.taskExecutor.removeTask(SqlTaskExecution.this.taskHandle);
                        SqlTaskExecution.this.sharedBuffer.destroy();
                    }
                }
            });
            this.taskContext = new TaskContext(this.taskStateMachine, notificationExecutor, session, (DataSize)Preconditions.checkNotNull((Object)maxTaskMemoryUsage, (Object)"maxTaskMemoryUsage is null"), (DataSize)Preconditions.checkNotNull((Object)operatorPreAllocatedMemory, (Object)"operatorPreAllocatedMemory is null"), cpuTimerEnabled);
            this.sharedBuffer = new SharedBuffer((DataSize)Preconditions.checkNotNull((Object)maxBufferSize, (Object)"maxBufferSize is null"));
            this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
            this.taskHandle = taskExecutor.addTask(taskId);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(session, fragment.getRoot(), fragment.getSymbols(), new TaskOutputOperator.TaskOutputFactory(this.sharedBuffer));
            List<DriverFactory> driverFactories = localExecutionPlan.getDriverFactories();
            DriverFactory partitionedDriverFactory = null;
            ArrayList<Driver> unpartitionedDrivers = new ArrayList<Driver>();
            for (DriverFactory driverFactory : driverFactories) {
                if (driverFactory.getSourceIds().contains(fragment.getPartitionedSource())) {
                    partitionedDriverFactory = driverFactory;
                    continue;
                }
                PipelineContext pipelineContext = this.taskContext.addPipelineContext(driverFactory.isInputDriver(), driverFactory.isOutputDriver());
                Driver driver = driverFactory.createDriver(pipelineContext.addDriverContext());
                unpartitionedDrivers.add(driver);
            }
            this.unpartitionedDrivers = ImmutableList.copyOf(unpartitionedDrivers);
            Preconditions.checkArgument((!fragment.isPartitioned() || partitionedDriverFactory != null ? 1 : 0) != 0, (Object)"Fragment is partitioned, but no partitioned driver found");
            if (partitionedDriverFactory != null) {
                this.partitionedSourceId = fragment.getPartitionedSource();
                this.partitionedDriverFactory = partitionedDriverFactory;
                this.partitionedPipelineContext = this.taskContext.addPipelineContext(partitionedDriverFactory.isInputDriver(), partitionedDriverFactory.isOutputDriver());
            } else {
                this.partitionedSourceId = null;
                this.partitionedDriverFactory = null;
                this.partitionedPipelineContext = null;
            }
        }
    }

    private void start() {
        for (Driver driver : this.unpartitionedDrivers) {
            this.drivers.add(new WeakReference<Driver>(driver));
            this.enqueueDriver(true, new DriverSplitRunner(driver));
        }
    }

    @Override
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void waitForStateChange(TaskState currentState, Duration maxWait) throws InterruptedException {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.waitForStateChange(currentState, maxWait);
        }
    }

    @Override
    public TaskInfo getTaskInfo(boolean full) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.checkTaskCompletion();
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures(this.taskStateMachine.getFailureCauses());
            }
            TaskInfo taskInfo = new TaskInfo(this.taskStateMachine.getTaskId(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, this.lastHeartbeat.get(), this.sharedBuffer.getInfo(), this.getNoMoreSplits(), this.taskContext.getTaskStats(), (List<FailureInfo>)failures, this.taskContext.getOutputItems());
            return taskInfo;
        }
    }

    @Override
    public void addSources(List<TaskSource> sources) {
        Preconditions.checkNotNull(sources, (Object)"sources is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not add sources while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            Map<PlanNodeId, TaskSource> updatedUnpartitionedSources = this.updateSources(sources);
            for (TaskSource source : updatedUnpartitionedSources.values()) {
                for (WeakReference<Driver> driverReference : this.drivers) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver != null) {
                        driver.updateSource(source);
                        continue;
                    }
                    this.drivers.remove(driverReference);
                }
            }
        }
    }

    private synchronized Map<PlanNodeId, TaskSource> updateSources(List<TaskSource> sources) {
        HashMap<PlanNodeId, TaskSource> updatedUnpartitionedSources = new HashMap<PlanNodeId, TaskSource>();
        long newMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        for (TaskSource source : sources) {
            PlanNodeId sourceId = source.getPlanNodeId();
            if (sourceId.equals(this.partitionedSourceId)) {
                for (final ScheduledSplit scheduledSplit : source.getSplits()) {
                    if (scheduledSplit.getSequenceId() <= this.maxAcknowledgedSplit) continue;
                    this.enqueueDriver(false, new DriverSplitRunner(this.partitionedPipelineContext.addDriverContext(), (Function)new Function<DriverContext, Driver>(){

                        public Driver apply(DriverContext driverContext) {
                            return SqlTaskExecution.this.createDriver(SqlTaskExecution.this.partitionedDriverFactory, driverContext, scheduledSplit);
                        }
                    }));
                    newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
                }
                if (!source.isNoMoreSplits()) continue;
                this.noMorePartitionedSplits.set(true);
                this.checkNoMorePartitionedSplits();
                continue;
            }
            for (final ScheduledSplit scheduledSplit : source.getSplits()) {
                newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
            }
            TaskSource currentSource = (TaskSource)this.unpartitionedSources.get(sourceId);
            TaskSource newSource = currentSource == null ? source : currentSource.update(source);
            if (newSource == currentSource) continue;
            this.unpartitionedSources.put(sourceId, newSource);
            updatedUnpartitionedSources.put(sourceId, newSource);
        }
        this.maxAcknowledgedSplit = newMaxAcknowledgedSplit;
        return updatedUnpartitionedSources;
    }

    @Override
    public synchronized void addResultQueue(OutputBuffers outputIds) {
        Preconditions.checkNotNull((Object)outputIds, (Object)"outputIds is null");
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            for (String bufferId : outputIds.getBufferIds()) {
                this.sharedBuffer.addQueue(bufferId);
            }
            if (outputIds.isNoMoreBufferIds()) {
                this.sharedBuffer.noMoreQueues();
            }
        }
    }

    private synchronized void enqueueDriver(boolean forceRunSplit, final DriverSplitRunner splitRunner) {
        ListenableFuture<?> finishedFuture = forceRunSplit ? this.taskExecutor.forceRunSplit(this.taskHandle, splitRunner) : this.taskExecutor.enqueueSplit(this.taskHandle, splitRunner);
        this.remainingDriverCount.incrementAndGet();
        Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                try (SetThreadName setThreadName = new SetThreadName("Task-%s", SqlTaskExecution.this.taskId);){
                    int runningCount = SqlTaskExecution.this.remainingDriverCount.decrementAndGet();
                    if (runningCount <= 0) {
                        SqlTaskExecution.this.checkNoMorePartitionedSplits();
                    }
                    SqlTaskExecution.this.checkTaskCompletion();
                    SqlTaskExecution.this.queryMonitor.splitCompletionEvent(SqlTaskExecution.this.taskId, splitRunner.getDriverContext().getDriverStats());
                }
            }

            public void onFailure(Throwable cause) {
                try (SetThreadName setThreadName = new SetThreadName("Task-%s", SqlTaskExecution.this.taskId);){
                    SqlTaskExecution.this.taskStateMachine.failed(cause);
                    SqlTaskExecution.this.remainingDriverCount.decrementAndGet();
                    SqlTaskExecution.this.checkNoMorePartitionedSplits();
                    SqlTaskExecution.this.queryMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, splitRunner.getDriverContext().getDriverStats(), cause);
                }
            }
        });
    }

    private void checkNoMorePartitionedSplits() {
        if (this.partitionedDriverFactory != null && this.noMorePartitionedSplits.get() && this.remainingDriverCount.get() <= 0) {
            this.partitionedDriverFactory.close();
        }
    }

    private Driver createDriver(DriverFactory driverFactory, DriverContext driverContext, ScheduledSplit partitionedSplit) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not crete a driver while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        Driver driver = driverFactory.createDriver(driverContext);
        if (partitionedSplit != null) {
            driver.updateSource(new TaskSource(this.partitionedSourceId, (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
        }
        this.drivers.add(new WeakReference<Driver>(driver));
        for (TaskSource source : this.unpartitionedSources.values()) {
            driver.updateSource(source);
        }
        return driver;
    }

    private Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        if (this.partitionedSourceId != null && this.noMorePartitionedSplits.get()) {
            noMoreSplits.add((Object)this.partitionedSourceId);
        }
        for (TaskSource taskSource : this.unpartitionedSources.values()) {
            if (!taskSource.isNoMoreSplits()) continue;
            noMoreSplits.add((Object)taskSource.getPlanNodeId());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.partitionedSourceId != null && !this.noMorePartitionedSplits.get()) {
            return;
        }
        if (this.remainingDriverCount.get() != 0) {
            return;
        }
        this.sharedBuffer.finish();
        if (!this.sharedBuffer.isFinished()) {
            return;
        }
        this.taskStateMachine.finished();
    }

    @Override
    public void cancel() {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.cancel();
        }
    }

    @Override
    public void fail(Throwable cause) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.taskStateMachine.failed(cause);
        }
    }

    @Override
    public BufferResult getResults(String outputId, long startingSequenceId, DataSize maxSize, Duration maxWait) throws InterruptedException {
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not get result data while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            BufferResult bufferResult = this.sharedBuffer.get(outputId, startingSequenceId, maxSize, maxWait);
            return bufferResult;
        }
    }

    @Override
    public void abortResults(String outputId) {
        try (SetThreadName setThreadName = new SetThreadName("Task-%s", this.taskId);){
            this.sharedBuffer.abort(outputId);
        }
    }

    @Override
    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("unpartitionedSources", this.unpartitionedSources).toString();
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverContext driverContext;
        private final Function<? super DriverContext, Driver> driverSupplier;
        private Driver driver;

        public DriverSplitRunner(Driver driver) {
            this(driver.getDriverContext(), (Function<? super DriverContext, Driver>)Functions.constant((Object)driver));
        }

        private DriverSplitRunner(DriverContext driverContext, Function<? super DriverContext, Driver> driverFactory) {
            this.driverContext = (DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
            this.driverSupplier = (Function)Preconditions.checkNotNull(driverFactory, (Object)"driverFactory is null");
        }

        public DriverContext getDriverContext() {
            return this.driverContext;
        }

        @Override
        public synchronized void initialize() {
            this.driver = (Driver)this.driverSupplier.apply((Object)this.driverContext);
        }

        @Override
        public synchronized boolean isFinished() {
            return this.driver.isFinished();
        }

        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            return this.driver.processFor(duration);
        }

        @Override
        public void close() {
            if (this.driver != null) {
                this.driver.close();
            }
        }
    }
}

