/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataSource;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageExecutionNode;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.Split;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.OutputReceiver;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.util.SetThreadName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SqlStageExecution
implements StageExecutionNode {
    private static final Logger log = Logger.get(SqlStageExecution.class);
    @Nullable
    private final StageExecutionNode parent;
    private final StageId stageId;
    private final URI location;
    private final PlanFragment fragment;
    private final List<TupleInfo> tupleInfos;
    private final Map<PlanFragmentId, StageExecutionNode> subStages;
    private final Map<PlanNodeId, OutputReceiver> outputReceivers;
    private final ConcurrentMap<Node, RemoteTask> tasks = new ConcurrentHashMap<Node, RemoteTask>();
    private final Optional<DataSource> dataSource;
    private final RemoteTaskFactory remoteTaskFactory;
    private final Session session;
    private final int maxPendingSplitsPerNode;
    private final StateMachine<StageState> stageState;
    private final LinkedBlockingQueue<Throwable> failureCauses = new LinkedBlockingQueue();
    @GuardedBy(value="this")
    private final Set<String> outputBuffers = new TreeSet<String>();
    @GuardedBy(value="this")
    private boolean noMoreOutputIds;
    private final ExecutorService executor;
    private final Distribution getSplitDistribution = new Distribution();
    private final Distribution scheduleTaskDistribution = new Distribution();
    private final Distribution addSplitDistribution = new Distribution();
    private final NodeScheduler.NodeSelector nodeSelector;

    public SqlStageExecution(QueryId queryId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int maxPendingSplitsPerNode, ExecutorService executor) {
        this(null, queryId, new AtomicInteger(), locationFactory, plan, nodeScheduler, remoteTaskFactory, session, maxPendingSplitsPerNode, executor);
    }

    private SqlStageExecution(@Nullable StageExecutionNode parent, QueryId queryId, AtomicInteger nextStageId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int maxPendingSplitsPerNode, ExecutorService executor) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)nextStageId, (Object)"nextStageId is null");
        Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)nodeScheduler, (Object)"nodeScheduler is null");
        Preconditions.checkNotNull((Object)remoteTaskFactory, (Object)"remoteTaskFactory is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkArgument((maxPendingSplitsPerNode > 0 ? 1 : 0) != 0, (Object)"maxPendingSplitsPerNode must be greater than 0");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.stageId = new StageId(queryId, String.valueOf(nextStageId.getAndIncrement()));
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.parent = parent;
            this.location = locationFactory.createStageLocation(this.stageId);
            this.fragment = plan.getFragment();
            this.outputReceivers = plan.getOutputReceivers();
            this.dataSource = plan.getDataSource();
            this.remoteTaskFactory = remoteTaskFactory;
            this.session = session;
            this.maxPendingSplitsPerNode = maxPendingSplitsPerNode;
            this.executor = executor;
            this.tupleInfos = this.fragment.getTupleInfos();
            ImmutableMap.Builder subStages = ImmutableMap.builder();
            for (StageExecutionPlan subStagePlan : plan.getSubStages()) {
                PlanFragmentId subStageFragmentId = subStagePlan.getFragment().getId();
                SqlStageExecution subStage = new SqlStageExecution(this, queryId, nextStageId, locationFactory, subStagePlan, nodeScheduler, remoteTaskFactory, session, maxPendingSplitsPerNode, executor);
                subStage.addStateChangeListener(new StateMachine.StateChangeListener<StageInfo>(){

                    @Override
                    public void stateChanged(StageInfo stageInfo) {
                        SqlStageExecution.this.doUpdateState();
                    }
                });
                subStages.put((Object)subStageFragmentId, (Object)subStage);
            }
            this.subStages = subStages.build();
            String dataSourceName = this.dataSource.isPresent() ? ((DataSource)this.dataSource.get()).getDataSourceName() : null;
            this.nodeSelector = nodeScheduler.createNodeSelector(dataSourceName, (Comparator<Node>)Ordering.natural().onResultOf((Function)new Function<Node, Integer>(){

                public Integer apply(Node input) {
                    RemoteTask task = (RemoteTask)SqlStageExecution.this.tasks.get(input);
                    return task == null ? 0 : task.getQueuedSplits();
                }
            }));
            this.stageState = new StateMachine<StageState>("stage " + this.stageId, this.executor, StageState.PLANNED);
            this.stageState.addStateChangeListener(new StateMachine.StateChangeListener<StageState>(){

                @Override
                public void stateChanged(StageState newValue) {
                    log.debug("Stage %s is %s", new Object[]{SqlStageExecution.this.stageId, newValue});
                }
            });
        }
    }

    @Override
    public void cancelStage(StageId stageId) {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", stageId);){
            if (stageId.equals(this.stageId)) {
                this.cancel(true);
            } else {
                for (StageExecutionNode subStage : this.subStages.values()) {
                    subStage.cancelStage(stageId);
                }
            }
        }
    }

    @Override
    @VisibleForTesting
    public StageState getState() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            StageState stageState = this.stageState.get();
            return stageState;
        }
    }

    @Override
    public StageInfo getStageInfo() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            List<TaskInfo> taskInfos = IterableTransformer.on(this.tasks.values()).transform(SqlStageExecution.taskInfoGetter()).list();
            List<StageInfo> subStageInfos = IterableTransformer.on(this.subStages.values()).transform(SqlStageExecution.stageInfoGetter()).list();
            int totalTasks = taskInfos.size();
            int runningTasks = 0;
            int completedTasks = 0;
            int totalDrivers = 0;
            int queuedDrivers = 0;
            int runningDrivers = 0;
            int completedDrivers = 0;
            long totalMemoryReservation = 0L;
            long totalScheduledTime = 0L;
            long totalCpuTime = 0L;
            long totalUserTime = 0L;
            long totalBlockedTime = 0L;
            long rawInputDataSize = 0L;
            long rawInputPositions = 0L;
            long processedInputDataSize = 0L;
            long processedInputPositions = 0L;
            long outputDataSize = 0L;
            long outputPositions = 0L;
            for (TaskInfo taskInfo : taskInfos) {
                if (taskInfo.getState().isDone()) {
                    ++completedTasks;
                } else {
                    ++runningTasks;
                }
                TaskStats taskStats = taskInfo.getStats();
                totalDrivers += taskStats.getTotalDrivers();
                queuedDrivers += taskStats.getQueuedDrivers();
                runningDrivers += taskStats.getRunningDrivers();
                completedDrivers += taskStats.getCompletedDrivers();
                totalMemoryReservation += taskStats.getMemoryReservation().toBytes();
                totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
                totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
                totalUserTime += taskStats.getTotalUserTime().roundTo(TimeUnit.NANOSECONDS);
                totalBlockedTime += taskStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
                rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
                rawInputPositions += taskStats.getRawInputPositions();
                processedInputDataSize += taskStats.getProcessedInputDataSize().toBytes();
                processedInputPositions += taskStats.getProcessedInputPositions();
                outputDataSize += taskStats.getOutputDataSize().toBytes();
                outputPositions += taskStats.getOutputPositions();
            }
            StageStats stageStats = new StageStats(this.getSplitDistribution.snapshot(), this.scheduleTaskDistribution.snapshot(), this.addSplitDistribution.snapshot(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, new DataSize((double)totalMemoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)rawInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), rawInputPositions, new DataSize((double)processedInputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), processedInputPositions, new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions);
            StageInfo stageInfo = new StageInfo(this.stageId, this.stageState.get(), this.location, this.fragment, this.tupleInfos, stageStats, taskInfos, subStageInfos, Failures.toFailures(this.failureCauses));
            return stageInfo;
        }
    }

    private synchronized Set<String> getOutputBuffers() {
        return ImmutableSet.copyOf(this.outputBuffers);
    }

    @Override
    public synchronized void addOutputBuffer(String outputId) {
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        Preconditions.checkArgument((!this.outputBuffers.contains(outputId) ? 1 : 0) != 0, (String)"Stage already has an output %s", (Object[])new Object[]{outputId});
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.outputBuffers.add(outputId);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void noMoreOutputBuffers() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.noMoreOutputIds = true;
            this.notifyAll();
        }
    }

    @Override
    public void addStateChangeListener(final StateMachine.StateChangeListener<StageInfo> stateChangeListener) {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            this.stageState.addStateChangeListener(new StateMachine.StateChangeListener<StageState>(){

                @Override
                public void stateChanged(StageState newValue) {
                    stateChangeListener.stateChanged(SqlStageExecution.this.getStageInfo());
                }
            });
        }
    }

    private Multimap<PlanNodeId, URI> getExchangeLocations() {
        ImmutableMultimap.Builder exchangeLocations = ImmutableMultimap.builder();
        for (PlanNode planNode : this.fragment.getSources()) {
            if (!(planNode instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)planNode;
            for (PlanFragmentId planFragmentId : exchangeNode.getSourceFragmentIds()) {
                StageExecutionNode subStage = this.subStages.get(planFragmentId);
                Preconditions.checkState((subStage != null ? 1 : 0) != 0, (String)"Unknown sub stage %s, known stages %s", (Object[])new Object[]{planFragmentId, this.subStages.keySet()});
                exchangeLocations.putAll((Object)exchangeNode.getId(), subStage.getTaskLocations());
            }
        }
        return exchangeLocations.build();
    }

    @VisibleForTesting
    public synchronized List<URI> getTaskLocations() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            ImmutableList.Builder locations = ImmutableList.builder();
            for (RemoteTask task : this.tasks.values()) {
                locations.add((Object)task.getTaskInfo().getSelf());
            }
            ImmutableList immutableList = locations.build();
            return immutableList;
        }
    }

    public Future<?> start() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            Future<?> future = this.scheduleStartTasks();
            return future;
        }
    }

    @Override
    @VisibleForTesting
    public Future<?> scheduleStartTasks() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            for (StageExecutionNode subStage : this.subStages.values()) {
                subStage.scheduleStartTasks();
            }
            Future<?> future = this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    SqlStageExecution.this.startTasks();
                }
            });
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startTasks() {
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            try {
                Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not start while holding a lock on this");
                SqlStageExecution sqlStageExecution = this;
                synchronized (sqlStageExecution) {
                    if (!this.stageState.compareAndSet(StageState.PLANNED, StageState.SCHEDULING)) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 12] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                        this.doUpdateState();
                        return;
                    }
                }
                AtomicInteger nextTaskId = new AtomicInteger(0);
                if (!this.dataSource.isPresent()) {
                    this.scheduleTask(nextTaskId, this.nodeSelector.selectRandomNode(), null);
                } else {
                    long getSplitStart = System.nanoTime();
                    for (Split split : ((DataSource)this.dataSource.get()).getSplits()) {
                        this.getSplitDistribution.add(System.nanoTime() - getSplitStart);
                        long scheduleSplitStart = System.nanoTime();
                        Node chosen = this.chooseNode(this.nodeSelector, split, nextTaskId);
                        if (this.getState().isDone()) break;
                        RemoteTask task = (RemoteTask)this.tasks.get(chosen);
                        if (task == null) {
                            this.scheduleTask(nextTaskId, chosen, split);
                            this.scheduleTaskDistribution.add(System.nanoTime() - scheduleSplitStart);
                        } else {
                            task.addSplit(split);
                            this.addSplitDistribution.add(System.nanoTime() - scheduleSplitStart);
                        }
                        getSplitStart = System.nanoTime();
                    }
                    for (RemoteTask task : this.tasks.values()) {
                        task.noMoreSplits();
                    }
                }
                this.stageState.set(StageState.SCHEDULED);
                Iterator<StageExecutionNode> i$ = this.subStages.values().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        this.addNewExchangesAndBuffers(true);
                        this.doUpdateState();
                        return;
                    }
                    StageExecutionNode subStage = i$.next();
                    subStage.noMoreOutputBuffers();
                }
            }
            catch (Throwable e) {
                try {
                    if (!this.getState().isDone()) {
                        SqlStageExecution sqlStageExecution = this;
                        synchronized (sqlStageExecution) {
                            this.failureCauses.add(e);
                            this.stageState.set(StageState.FAILED);
                        }
                        log.error(e, "Error while starting stage %s", new Object[]{this.stageId});
                        this.cancel(true);
                        throw e;
                    }
                    Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
                    log.debug(e, "Error while starting stage in done query %s", new Object[]{this.stageId});
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.doUpdateState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node chooseNode(NodeScheduler.NodeSelector nodeSelector, Split split, AtomicInteger nextTaskId) {
        while (!this.getState().isDone()) {
            Node chosen = nodeSelector.selectNode(split);
            RemoteTask task = (RemoteTask)this.tasks.get(chosen);
            if (task == null || task.getQueuedSplits() < this.maxPendingSplitsPerNode) {
                return chosen;
            }
            if (!this.subStages.isEmpty()) {
                nodeSelector.lockDownNodes();
                for (Node node : Sets.difference(new HashSet<Node>(nodeSelector.allNodes()), this.tasks.keySet())) {
                    this.scheduleTask(nextTaskId, node, null);
                }
                for (StageExecutionNode subStage : this.subStages.values()) {
                    subStage.noMoreOutputBuffers();
                }
            }
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                try {
                    TimeUnit.SECONDS.timedWait(this, 1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
            }
            this.addNewExchangesAndBuffers(false);
        }
        return null;
    }

    private RemoteTask scheduleTask(AtomicInteger nextTaskId, Node node, @Nullable Split initialSplit) {
        String nodeIdentifier = node.getNodeIdentifier();
        TaskId taskId = new TaskId(this.stageId, String.valueOf(nextTaskId.getAndIncrement()));
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(this.session, taskId, node, this.fragment, initialSplit, this.outputReceivers, this.getExchangeLocations(), this.getOutputBuffers());
        task.addStateChangeListener(new StateMachine.StateChangeListener<TaskInfo>(){

            @Override
            public void stateChanged(TaskInfo taskInfo) {
                SqlStageExecution.this.doUpdateState();
            }
        });
        task.start();
        this.tasks.put(node, task);
        this.doUpdateState();
        if (this.getState().isDone()) {
            return task;
        }
        for (StageExecutionNode subStage : this.subStages.values()) {
            subStage.addOutputBuffer(nodeIdentifier);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewExchangesAndBuffers(boolean waitUntilFinished) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not add exchanges or buffers to tasks while holding a lock on this");
        while (!this.getState().isDone()) {
            boolean outputComplete;
            boolean exchangesComplete = this.exchangesAreComplete();
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                outputComplete = this.noMoreOutputIds;
            }
            Multimap<PlanNodeId, URI> exchangeLocations = this.getExchangeLocations();
            Set<String> outputBuffers = this.getOutputBuffers();
            for (RemoteTask task : this.tasks.values()) {
                task.addExchangeLocations(exchangeLocations, exchangesComplete);
                task.addOutputBuffers(outputBuffers, outputComplete);
            }
            if (exchangesComplete && outputComplete) {
                return;
            }
            if (!waitUntilFinished) continue;
            this.waitForMoreExchangesAndBuffers(exchangeLocations, exchangesComplete, outputBuffers, outputComplete);
        }
    }

    private synchronized void waitForMoreExchangesAndBuffers(Multimap<PlanNodeId, URI> exchangeLocations, boolean exchangesComplete, Set<String> outputBuffers, boolean outputComplete) {
        while (!this.getState().isDone()) {
            if (this.exchangesAreComplete() && this.noMoreOutputIds) {
                return;
            }
            if (exchangesComplete != this.exchangesAreComplete()) {
                return;
            }
            if (outputComplete != this.noMoreOutputIds) {
                return;
            }
            if (!outputBuffers.equals(this.getOutputBuffers())) {
                return;
            }
            if (!exchangeLocations.equals(this.getExchangeLocations())) {
                return;
            }
            try {
                TimeUnit.SECONDS.timedWait(this, 1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private boolean exchangesAreComplete() {
        for (StageExecutionNode subStage : this.subStages.values()) {
            switch (subStage.getState()) {
                case PLANNED: 
                case SCHEDULING: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doUpdateState() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not doUpdateState while holding a lock on this");
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                StageState currentState;
                block28: {
                    this.notifyAll();
                    currentState = this.stageState.get();
                    if (!currentState.isDone()) break block28;
                    return;
                }
                ImmutableList subStageStates = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.transform(this.subStages.values(), SqlStageExecution.stageInfoGetter()), StageInfo.stageStateGetter()));
                if (Iterables.any((Iterable)subStageStates, (Predicate)Predicates.equalTo((Object)((Object)StageState.FAILED)))) {
                    this.stageState.set(StageState.FAILED);
                } else {
                    ImmutableList taskStates = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.transform(this.tasks.values(), SqlStageExecution.taskInfoGetter()), TaskInfo.taskStateGetter()));
                    if (Iterables.any((Iterable)taskStates, (Predicate)Predicates.equalTo((Object)((Object)TaskState.FAILED)))) {
                        this.stageState.set(StageState.FAILED);
                    } else if (currentState != StageState.PLANNED && currentState != StageState.SCHEDULING) {
                        if (Iterables.all((Iterable)taskStates, TaskState.inDoneState())) {
                            this.stageState.set(StageState.FINISHED);
                        } else if (Iterables.any((Iterable)taskStates, (Predicate)Predicates.equalTo((Object)((Object)TaskState.RUNNING)))) {
                            this.stageState.set(StageState.RUNNING);
                        }
                    }
                }
            }
            if (this.stageState.get().isDone()) {
                this.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(boolean force) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not cancel while holding a lock on this");
        try (SetThreadName setThreadName = new SetThreadName("Stage-%s", this.stageId);){
            SqlStageExecution waitTime;
            if (!force) {
                waitTime = new Duration(100.0, TimeUnit.MILLISECONDS);
                for (RemoteTask remoteTask : this.tasks.values()) {
                    try {
                        waitTime = remoteTask.waitForTaskToFinish((Duration)waitTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
            this.doUpdateState();
            waitTime = this;
            synchronized (waitTime) {
                if (!this.stageState.get().isDone()) {
                    log.debug("Cancelling stage %s", new Object[]{this.stageId});
                    this.stageState.set(StageState.CANCELED);
                }
            }
            for (RemoteTask task : this.tasks.values()) {
                task.cancel();
            }
            for (StageExecutionNode subStage : this.subStages.values()) {
                subStage.cancel(force);
            }
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("location", (Object)this.location).add("stageState", (Object)this.stageState.get()).toString();
    }

    public static Function<RemoteTask, TaskInfo> taskInfoGetter() {
        return new Function<RemoteTask, TaskInfo>(){

            public TaskInfo apply(RemoteTask remoteTask) {
                return remoteTask.getTaskInfo();
            }
        };
    }

    public static Function<StageExecutionNode, StageInfo> stageInfoGetter() {
        return new Function<StageExecutionNode, StageInfo>(){

            public StageInfo apply(StageExecutionNode stage) {
                return stage.getStageInfo();
            }
        };
    }
}

