/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryInfo;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlQueryManagerStats {
    private final CounterStat startedQueries = new CounterStat();
    private final CounterStat completedQueries = new CounterStat();
    private final DistributionStat executionTime = new DistributionStat();

    public void queryStarted() {
        this.startedQueries.update(1L);
    }

    public void queryFinished(QueryInfo info) {
        this.completedQueries.update(1L);
        this.executionTime.add(info.getQueryStats().getEndTime().getMillis() - info.getQueryStats().getCreateTime().getMillis());
    }

    @Managed
    public long getRunningQueries() {
        return Math.max(0L, this.startedQueries.getTotalCount() - this.completedQueries.getTotalCount());
    }

    @Managed
    @Nested
    public CounterStat getStartedQueries() {
        return this.startedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCompletedQueries() {
        return this.completedQueries;
    }

    @Managed
    @Nested
    public DistributionStat getExecutionTime() {
        return this.executionTime;
    }
}

