/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.Page;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class BufferResult {
    private final long startingSequenceId;
    private final boolean bufferClosed;
    private final List<Page> elements;

    public static BufferResult emptyResults(long endSequenceId, boolean bufferClosed) {
        return new BufferResult(endSequenceId, bufferClosed, (List<Page>)ImmutableList.of());
    }

    public static BufferResult bufferResult(long startingSequenceId, Page firstElement, Page ... otherElements) {
        return new BufferResult(startingSequenceId, false, (List<Page>)ImmutableList.builder().add((Object)firstElement).add((Object[])otherElements).build());
    }

    public BufferResult(long startingSequenceId, boolean bufferClosed, List<Page> elements) {
        this.startingSequenceId = startingSequenceId;
        this.bufferClosed = bufferClosed;
        this.elements = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(elements, (Object)"pages is null")));
    }

    public long getStartingSequenceId() {
        return this.startingSequenceId;
    }

    public boolean isBufferClosed() {
        return this.bufferClosed;
    }

    public List<Page> getElements() {
        return this.elements;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bufferClosed, this.elements});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BufferResult other = (BufferResult)obj;
        return Objects.equal((Object)this.bufferClosed, (Object)other.bufferClosed) && Objects.equal(this.elements, other.elements);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("bufferClosed", this.bufferClosed).add("elements", this.elements).toString();
    }
}

