/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.google.common.base.Preconditions;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@EventType(value="SplitCompletion")
@Immutable
public class SplitCompletionEvent {
    private final QueryId queryId;
    private final StageId stageId;
    private final TaskId taskId;
    private final String environment;
    private final Duration queuedTimeMs;
    private final DateTime executionStartTime;
    private final Long timeToFirstByteMs;
    private final Long timeToLastByteMs;
    private final DataSize completedDataSize;
    private final long completedPositions;
    private final Long wallTimeMs;
    private final Long cpuTimeMs;
    private final Long userTimeMs;
    private final String failureType;
    private final String failureMessage;
    private final String splitInfoJson;

    public SplitCompletionEvent(QueryId queryId, StageId stageId, TaskId taskId, String environment, Duration queuedTimeMs, @Nullable DateTime executionStartTime, @Nullable Duration timeToFirstByte, @Nullable Duration timeToLastByte, DataSize completedDataSize, long completedPositions, @Nullable Duration wallTime, @Nullable Duration cpuTime, @Nullable Duration userTime, @Nullable String failureType, @Nullable String failureMessage, String splitInfoJson) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)completedDataSize, (Object)"completedDataSize is null");
        Preconditions.checkNotNull((Object)completedPositions, (Object)"completedPositions is null");
        Preconditions.checkNotNull((Object)splitInfoJson, (Object)"splitInfoJson is null");
        this.queryId = queryId;
        this.stageId = stageId;
        this.taskId = taskId;
        this.environment = environment;
        this.queuedTimeMs = queuedTimeMs;
        this.executionStartTime = executionStartTime;
        this.timeToFirstByteMs = SplitCompletionEvent.durationToMillis(timeToFirstByte);
        this.timeToLastByteMs = SplitCompletionEvent.durationToMillis(timeToLastByte);
        this.completedDataSize = completedDataSize;
        this.completedPositions = completedPositions;
        this.wallTimeMs = SplitCompletionEvent.durationToMillis(wallTime);
        this.cpuTimeMs = SplitCompletionEvent.durationToMillis(cpuTime);
        this.userTimeMs = SplitCompletionEvent.durationToMillis(userTime);
        this.failureType = failureType;
        this.failureMessage = failureMessage;
        this.splitInfoJson = splitInfoJson;
    }

    @Nullable
    private static Long durationToMillis(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    @EventField
    public String getQueryId() {
        return this.queryId.toString();
    }

    @EventField
    public String getStageId() {
        return this.stageId.toString();
    }

    @EventField
    public String getTaskId() {
        return this.taskId.toString();
    }

    @EventField
    public String getEnvironment() {
        return this.environment;
    }

    @EventField
    public long getQueuedTimeMs() {
        return this.queuedTimeMs.toMillis();
    }

    @EventField
    public DateTime getExecutionStartTime() {
        return this.executionStartTime;
    }

    @EventField
    public Long getTimeToFirstByteMs() {
        return this.timeToFirstByteMs;
    }

    @EventField
    public Long getTimeToLastByteMs() {
        return this.timeToLastByteMs;
    }

    @EventField
    public long getCompletedDataSizeTotal() {
        return this.completedDataSize.toBytes();
    }

    @EventField
    public long getCompletedPositionsTotal() {
        return this.completedPositions;
    }

    @EventField
    public Long getWallTimeMs() {
        return this.wallTimeMs;
    }

    @EventField
    public Long getCpuTimeMs() {
        return this.cpuTimeMs;
    }

    @EventField
    public Long getUserTimeMs() {
        return this.userTimeMs;
    }

    @EventField
    public String getFailureType() {
        return this.failureType;
    }

    @EventField
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @EventField
    public String getSplitInfoJson() {
        return this.splitInfoJson;
    }
}

