/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SystemTableHandle
implements TableHandle {
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public SystemTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
    }

    public SystemTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.schemaName = tableName.getSchemaName();
        this.tableName = tableName.getTableName();
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String toString() {
        return "system:" + this.schemaName + "." + this.tableName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schemaName, this.tableName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTableHandle other = (SystemTableHandle)obj;
        return Objects.equal((Object)this.schemaName, (Object)other.schemaName) && Objects.equal((Object)this.tableName, (Object)other.tableName);
    }
}

