/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SystemSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final ConcurrentMap<SchemaTableName, SystemTable> tables = new ConcurrentHashMap<SchemaTableName, SystemTable>();

    @Inject
    public SystemSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public void addTable(SystemTable systemTable) {
        Preconditions.checkNotNull((Object)systemTable, (Object)"systemTable is null");
        SchemaTableName tableName = systemTable.getTableMetadata().getTable();
        Preconditions.checkArgument((this.tables.putIfAbsent(tableName, systemTable) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableName});
    }

    public String getConnectorId() {
        return null;
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof SystemTableHandle;
    }

    public List<Partition> getPartitions(TableHandle table, Map<ColumnHandle, Object> bindings) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(bindings, (Object)"bindings is null");
        Preconditions.checkArgument((boolean)(table instanceof SystemTableHandle), (Object)"TableHandle must be an SystemTableHandle");
        SystemTableHandle systemTableHandle = (SystemTableHandle)table;
        return ImmutableList.of((Object)new SystemPartition(systemTableHandle, bindings));
    }

    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof SystemPartition), (Object)"Partition must be a system partition");
        SystemPartition systemPartition = (SystemPartition)partition;
        SystemTable systemTable = (SystemTable)this.tables.get(systemPartition.getTableHandle().getSchemaTableName());
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{systemPartition.getTableHandle().getTableName()});
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, Object> entry : systemPartition.getFilters().entrySet()) {
            SystemColumnHandle systemColumnHandle = (SystemColumnHandle)entry.getKey();
            filters.put((Object)systemColumnHandle.getColumnName(), entry.getValue());
        }
        if (systemTable.isDistributed()) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (Node node : this.nodeManager.getAllNodes().getActiveNodes()) {
                splits.add((Object)new SystemSplit(systemPartition.tableHandle, (Map<String, Object>)filters.build(), node.getHostAndPort()));
            }
            return splits.build();
        }
        HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
        SystemSplit split = new SystemSplit(systemPartition.tableHandle, (Map<String, Object>)filters.build(), address);
        return ImmutableList.of((Object)split);
    }

    public static class SystemPartition
    implements Partition {
        private final SystemTableHandle tableHandle;
        private final Map<ColumnHandle, Object> filters;

        public SystemPartition(SystemTableHandle tableHandle, Map<ColumnHandle, Object> filters) {
            this.tableHandle = (SystemTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
            this.filters = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(filters, (Object)"filters is null")));
        }

        public SystemTableHandle getTableHandle() {
            return this.tableHandle;
        }

        public String getPartitionId() {
            return this.tableHandle.getSchemaTableName().toString();
        }

        public Map<ColumnHandle, Object> getKeys() {
            return ImmutableMap.of();
        }

        public Map<ColumnHandle, Object> getFilters() {
            return this.filters;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("filters", this.filters).toString();
        }
    }
}

