/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemDataStreamProvider;
import com.facebook.presto.connector.system.SystemHandleResolver;
import com.facebook.presto.connector.system.SystemSplitManager;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import javax.inject.Inject;

public class SystemConnector
implements Connector {
    private final ClassToInstanceMap<Object> services;

    @Inject
    public SystemConnector(SystemTablesMetadata value, SystemSplitManager systemSplitManager, SystemDataStreamProvider systemDataStreamProvider) {
        ImmutableClassToInstanceMap.Builder services = ImmutableClassToInstanceMap.builder();
        services.put(ConnectorMetadata.class, (Object)value);
        services.put(ConnectorSplitManager.class, (Object)systemSplitManager);
        services.put(ConnectorDataStreamProvider.class, (Object)systemDataStreamProvider);
        services.put(ConnectorHandleResolver.class, (Object)new SystemHandleResolver());
        this.services = services.build();
    }

    public <T> T getService(Class<T> type) {
        return (T)this.services.getInstance(type);
    }
}

