/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.StaticConnector;
import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxDataStreamProvider;
import com.facebook.presto.connector.jmx.JmxHandleResolver;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import io.airlift.node.NodeInfo;
import java.util.Map;
import javax.inject.Inject;
import javax.management.MBeanServer;

public class JmxConnectorFactory
implements ConnectorFactory {
    private static final JmxHandleResolver HANDLE_RESOLVER = new JmxHandleResolver();
    private final MBeanServer mbeanServer;
    private final NodeManager nodeManager;
    private final NodeInfo nodeInfo;

    @Inject
    public JmxConnectorFactory(MBeanServer mbeanServer, NodeManager nodeManager, NodeInfo nodeInfo) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
    }

    public String getName() {
        return "jmx";
    }

    public Connector create(String connectorId, Map<String, String> properties) {
        JmxConnectorId jmxConnectorId = new JmxConnectorId(connectorId);
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        builder.put(ConnectorMetadata.class, (Object)new JmxMetadata(jmxConnectorId, this.mbeanServer));
        builder.put(ConnectorSplitManager.class, (Object)new JmxSplitManager(jmxConnectorId, this.nodeManager));
        builder.put(ConnectorDataStreamProvider.class, (Object)new JmxDataStreamProvider(jmxConnectorId, this.mbeanServer, this.nodeInfo));
        builder.put(ConnectorHandleResolver.class, (Object)HANDLE_RESOLVER);
        return new StaticConnector((Map<Class<?>, ?>)builder.build());
    }
}

