/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class InformationSchemaMetadata
implements ConnectorMetadata {
    public static final String INFORMATION_SCHEMA = "information_schema";
    public static final SchemaTableName TABLE_COLUMNS = new SchemaTableName("information_schema", "columns");
    public static final SchemaTableName TABLE_TABLES = new SchemaTableName("information_schema", "tables");
    public static final SchemaTableName TABLE_SCHEMATA = new SchemaTableName("information_schema", "schemata");
    public static final SchemaTableName TABLE_INTERNAL_FUNCTIONS = new SchemaTableName("information_schema", "__internal_functions__");
    public static final SchemaTableName TABLE_INTERNAL_PARTITIONS = new SchemaTableName("information_schema", "__internal_partitions__");
    public static final Map<SchemaTableName, TableMetadata> TABLES = MetadataUtil.SchemaMetadataBuilder.schemaMetadataBuilder().table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_COLUMNS).column("table_catalog", ColumnType.STRING).column("table_schema", ColumnType.STRING).column("table_name", ColumnType.STRING).column("column_name", ColumnType.STRING).column("ordinal_position", ColumnType.LONG).column("column_default", ColumnType.STRING).column("is_nullable", ColumnType.STRING).column("data_type", ColumnType.STRING).column("is_partition_key", ColumnType.STRING).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_TABLES).column("table_catalog", ColumnType.STRING).column("table_schema", ColumnType.STRING).column("table_name", ColumnType.STRING).column("table_type", ColumnType.STRING).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_SCHEMATA).column("catalog_name", ColumnType.STRING).column("schema_name", ColumnType.STRING).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_INTERNAL_FUNCTIONS).column("function_name", ColumnType.STRING).column("argument_types", ColumnType.STRING).column("return_type", ColumnType.STRING).column("function_type", ColumnType.STRING).column("description", ColumnType.STRING).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_INTERNAL_PARTITIONS).column("table_catalog", ColumnType.STRING).column("table_schema", ColumnType.STRING).column("table_name", ColumnType.STRING).column("partition_number", ColumnType.LONG).column("partition_key", ColumnType.STRING).column("partition_value", ColumnType.STRING).build()).build();
    private final String catalogName;

    public InformationSchemaMetadata(String catalogName) {
        this.catalogName = catalogName;
    }

    public boolean canHandle(TableHandle tableHandle) {
        if (!(tableHandle instanceof InformationSchemaTableHandle)) {
            return false;
        }
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)tableHandle;
        return handle.getCatalogName().equals(this.catalogName) && TABLES.containsKey(handle.getSchemaTableName());
    }

    private InformationSchemaTableHandle checkTableHandle(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof InformationSchemaTableHandle), (Object)"tableHandle is not an information schema table handle");
        InformationSchemaTableHandle handle = (InformationSchemaTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.getCatalogName().equals(this.catalogName), (String)"invalid table handle: expected catalog %s but got %s", (Object[])new Object[]{this.catalogName, handle.getCatalogName()});
        Preconditions.checkArgument((boolean)TABLES.containsKey(handle.getSchemaTableName()), (String)"table %s does not exist", (Object[])new Object[]{handle.getSchemaTableName()});
        return handle;
    }

    public List<String> listSchemaNames() {
        return ImmutableList.of((Object)INFORMATION_SCHEMA);
    }

    public TableHandle getTableHandle(SchemaTableName tableName) {
        if (!TABLES.containsKey(tableName)) {
            return null;
        }
        return new InformationSchemaTableHandle(this.catalogName, tableName.getSchemaName(), tableName.getTableName());
    }

    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        return TABLES.get(informationSchemaTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return ImmutableList.copyOf(TABLES.keySet());
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(TABLES.keySet(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)schemaNameOrNull), MetadataUtil.schemaNameGetter())));
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        TableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        if (MetadataUtil.findColumnMetadata(tableMetadata, columnName) == null) {
            return null;
        }
        return new InformationSchemaColumnHandle(columnName);
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        TableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        Preconditions.checkArgument((boolean)(columnHandle instanceof InformationSchemaColumnHandle), (Object)"columnHandle is not an instance of InformationSchemaColumnHandle");
        String columnName = ((InformationSchemaColumnHandle)columnHandle).getColumnName();
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName);
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object[])new Object[]{columnName, tableMetadata.getTable()});
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        TableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        return InformationSchemaColumnHandle.toInformationSchemaColumnHandles(tableMetadata);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, TableMetadata> entry : TABLES.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getColumns());
        }
        return builder.build();
    }

    public TableHandle createTable(TableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(TableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    static List<ColumnMetadata> informationSchemaTableColumns(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)TABLES.containsKey(tableName), (String)"table does not exist: %s", (Object[])new Object[]{tableName});
        return TABLES.get(tableName).getColumns();
    }
}

