/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.InternalTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class InformationSchemaDataStreamProvider
implements ConnectorDataStreamProvider {
    private final Metadata metadata;
    private final SplitManager splitManager;

    @Inject
    public InformationSchemaDataStreamProvider(Metadata metadata, SplitManager splitManager) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
    }

    @Override
    public boolean canHandle(Split split) {
        return split instanceof InformationSchemaSplit;
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        List<BlockIterable> channels = this.createChannels(split, columns);
        return new AlignmentOperator(operatorContext, channels);
    }

    private List<BlockIterable> createChannels(Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof InformationSchemaSplit), (String)"Split must be of type %s, not %s", (Object[])new Object[]{InformationSchemaSplit.class.getName(), split.getClass().getName()});
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        InformationSchemaTableHandle handle = ((InformationSchemaSplit)split).getTableHandle();
        Map<String, Object> filters = ((InformationSchemaSplit)split).getFilters();
        InternalTable table = this.getInformationSchemaTable(handle.getCatalogName(), handle.getSchemaTableName(), filters);
        ImmutableList.Builder list = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof InformationSchemaColumnHandle), (String)"column must be of type %s, not %s", (Object[])new Object[]{InformationSchemaColumnHandle.class.getName(), column.getClass().getName()});
            InformationSchemaColumnHandle internalColumn = (InformationSchemaColumnHandle)column;
            list.add((Object)table.getColumn(internalColumn.getColumnName()));
        }
        return list.build();
    }

    public InternalTable getInformationSchemaTable(String catalog, SchemaTableName table, Map<String, Object> filters) {
        if (table.equals((Object)InformationSchemaMetadata.TABLE_COLUMNS)) {
            return this.buildColumns(catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLES)) {
            return this.buildTables(catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_SCHEMATA)) {
            return this.buildSchemata(catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS)) {
            return this.buildFunctions();
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS)) {
            return this.buildPartitions(catalog, filters);
        }
        throw new IllegalArgumentException(String.format("table does not exist: %s", table));
    }

    private InternalTable buildColumns(String catalogName, Map<String, Object> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_COLUMNS));
        for (Map.Entry<QualifiedTableName, List<ColumnMetadata>> entry : this.getColumnsList(catalogName, filters).entrySet()) {
            QualifiedTableName tableName = entry.getKey();
            for (ColumnMetadata column : entry.getValue()) {
                table.add(table.getTupleInfo().builder().append(tableName.getCatalogName()).append(tableName.getSchemaName()).append(tableName.getTableName()).append(column.getName()).append(column.getOrdinalPosition() + 1).appendNull().append("YES").append(TupleInfo.Type.fromColumnType(column.getType()).getName()).append(column.isPartitionKey() ? "YES" : "NO").build());
            }
        }
        return table.build();
    }

    private Map<QualifiedTableName, List<ColumnMetadata>> getColumnsList(String catalogName, Map<String, Object> filters) {
        return this.metadata.listTableColumns(this.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildTables(String catalogName, Map<String, Object> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLES));
        for (QualifiedTableName name : this.getTablesList(catalogName, filters)) {
            table.add(table.getTupleInfo().builder().append(name.getCatalogName()).append(name.getSchemaName()).append(name.getTableName()).append("BASE TABLE").build());
        }
        return table.build();
    }

    private List<QualifiedTableName> getTablesList(String catalogName, Map<String, Object> filters) {
        return this.metadata.listTables(this.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildFunctions() {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS));
        for (FunctionInfo function : this.metadata.listFunctions()) {
            Iterable arguments = Iterables.transform(function.getArgumentTypes(), Type.nameGetter());
            String functionType = function.isAggregate() ? "aggregate" : (function.isWindow() ? "window" : (function.isDeterministic() ? "scalar" : "scalar (non-deterministic)"));
            table.add(table.getTupleInfo().builder().append(function.getName().toString()).append(Joiner.on((String)", ").join(arguments)).append(function.getReturnType().getName()).append(functionType).append(Strings.nullToEmpty((String)function.getDescription())).build());
        }
        return table.build();
    }

    private InternalTable buildSchemata(String catalogName) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_SCHEMATA));
        for (String schema : this.metadata.listSchemaNames(catalogName)) {
            table.add(table.getTupleInfo().builder().append(catalogName).append(schema).build());
        }
        return table.build();
    }

    private InternalTable buildPartitions(String catalogName, Map<String, Object> filters) {
        QualifiedTableName tableName = this.extractQualifiedTableName(catalogName, filters);
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS));
        int partitionNumber = 1;
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(tableName);
        Preconditions.checkArgument((boolean)tableHandle.isPresent(), (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableBiMap columnHandles = ImmutableBiMap.copyOf(this.metadata.getColumnHandles((TableHandle)tableHandle.get())).inverse();
        List<Partition> partitions = this.splitManager.getPartitions((TableHandle)tableHandle.get(), (Optional<Map<ColumnHandle, Object>>)Optional.absent());
        for (Partition partition : partitions) {
            for (Map.Entry entry : partition.getKeys().entrySet()) {
                ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
                String columnName = (String)columnHandles.get(columnHandle);
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()) : null;
                table.add(table.getTupleInfo().builder().append(catalogName).append(tableName.getSchemaName()).append(tableName.getTableName()).append(partitionNumber).append(columnName).append(value).build());
            }
            ++partitionNumber;
        }
        return table.build();
    }

    private QualifiedTableName extractQualifiedTableName(String catalogName, Map<String, Object> filters) {
        Optional<String> schemaName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_schema");
        Preconditions.checkArgument((boolean)schemaName.isPresent(), (String)"filter is required for column: %s.%s", (Object[])new Object[]{InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, "table_schema"});
        Optional<String> tableName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_name");
        Preconditions.checkArgument((boolean)tableName.isPresent(), (String)"filter is required for column: %s.%s", (Object[])new Object[]{InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, "table_name"});
        return new QualifiedTableName(catalogName, (String)schemaName.get(), (String)tableName.get());
    }

    private QualifiedTablePrefix extractQualifiedTablePrefix(String catalogName, Map<String, Object> filters) {
        return new QualifiedTablePrefix(catalogName, InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_schema"), InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_name"));
    }

    private static Optional<String> getFilterColumn(Map<String, Object> filters, String columnName) {
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            if (!entry.getKey().equals(columnName)) continue;
            if (!(entry.getValue() instanceof String)) break;
            return Optional.of((Object)((String)entry.getValue()));
        }
        return Optional.absent();
    }
}

