/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.dual;

import com.facebook.presto.connector.dual.DualSplit;
import com.facebook.presto.connector.dual.DualTableHandle;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class DualSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public DualSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public String getConnectorId() {
        return null;
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof DualTableHandle;
    }

    public List<Partition> getPartitions(TableHandle table, Map<ColumnHandle, Object> bindings) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(bindings, (Object)"bindings is null");
        Preconditions.checkArgument((boolean)(table instanceof DualTableHandle), (Object)"TableHandle must be a DualTableHandle");
        return ImmutableList.of((Object)new DualPartition());
    }

    public Iterable<Split> getPartitionSplits(TableHandle table, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        Partition partition = (Partition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof DualPartition), (Object)"Partition must be a dual partition");
        DualSplit split = new DualSplit(this.nodeManager.getCurrentNode().getHostAndPort());
        return ImmutableList.of((Object)split);
    }

    public static class DualPartition
    implements Partition {
        public String getPartitionId() {
            return "dual";
        }

        public Map<ColumnHandle, Object> getKeys() {
            return ImmutableMap.of();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).toString();
        }
    }
}

