/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.dual;

import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class DualSplit
implements Split {
    private final List<HostAddress> addresses;

    public DualSplit(HostAddress address) {
        this((List<HostAddress>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)address, (Object)"address is null")));
    }

    @JsonCreator
    public DualSplit(@JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkNotNull(addresses, (Object)"hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("addresses", this.addresses).toString();
    }
}

