/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.dual;

import com.facebook.presto.connector.dual.DualColumnHandle;
import com.facebook.presto.connector.dual.DualTableHandle;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class DualMetadata
implements ConnectorMetadata {
    @VisibleForTesting
    public static final MetadataManager DUAL_METADATA_MANAGER = new MetadataManager();
    public static final String NAME = "dual";
    public static final String COLUMN_NAME = "dummy";
    public static final ColumnMetadata COLUMN_METADATA;

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof DualTableHandle;
    }

    public List<String> listSchemaNames() {
        return ImmutableList.of();
    }

    public TableHandle getTableHandle(SchemaTableName table) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        if (!table.getTableName().equals(NAME)) {
            return null;
        }
        return new DualTableHandle(table.getSchemaName());
    }

    public TableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof DualTableHandle), (Object)"tableHandle is not a dual table handle");
        SchemaTableName tableName = new SchemaTableName(((DualTableHandle)tableHandle).getSchemaName(), NAME);
        return new TableMetadata(tableName, (List)ImmutableList.of((Object)COLUMN_METADATA));
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        return ImmutableList.of();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof DualTableHandle), (Object)"tableHandle is not a dual table handle");
        Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        if (!columnName.equals(COLUMN_NAME)) {
            return null;
        }
        return new DualColumnHandle(COLUMN_NAME);
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof DualTableHandle), (Object)"tableHandle is not a dual table handle");
        return ImmutableMap.of((Object)COLUMN_NAME, (Object)new DualColumnHandle(COLUMN_NAME));
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof DualTableHandle), (Object)"tableHandle is not a dual table handle");
        Preconditions.checkArgument((boolean)(columnHandle instanceof DualColumnHandle), (Object)"columnHandle is not an instance of DualColumnHandle");
        DualColumnHandle dualColumnHandle = (DualColumnHandle)columnHandle;
        Preconditions.checkArgument((boolean)dualColumnHandle.getColumnName().equals(COLUMN_NAME), (Object)"column handle is not for DUAL");
        return COLUMN_METADATA;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return ImmutableMap.of();
        }
        if (prefix.getTableName() != null && !prefix.getTableName().equals(NAME)) {
            return ImmutableMap.of();
        }
        SchemaTableName tableName = new SchemaTableName(prefix.getSchemaName(), NAME);
        return ImmutableMap.of((Object)tableName, (Object)ImmutableList.of((Object)COLUMN_METADATA));
    }

    public TableHandle createTable(TableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(TableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    public List<ColumnMetadata> listTableColumns(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof DualTableHandle), (Object)"tableHandle is not a dual table handle");
        return ImmutableList.of((Object)COLUMN_METADATA);
    }

    static {
        DUAL_METADATA_MANAGER.addInternalSchemaMetadata(new DualMetadata());
        COLUMN_METADATA = new ColumnMetadata(COLUMN_NAME, ColumnType.STRING, 0, false);
    }
}

