/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.StaticConnector;
import com.facebook.presto.metadata.ForMetadata;
import com.facebook.presto.metadata.NativeHandleResolver;
import com.facebook.presto.metadata.NativeMetadata;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.NativeDataStreamProvider;
import com.facebook.presto.split.NativeSplitManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class NativeConnectorFactory
implements ConnectorFactory {
    private static final NativeHandleResolver HANDLE_RESOLVER = new NativeHandleResolver();
    private final AtomicReference<IDBI> dbi = new AtomicReference();
    private final AtomicReference<NativeSplitManager> splitManager = new AtomicReference();
    private final NativeDataStreamProvider dataStreamProvider;

    @Inject
    public NativeConnectorFactory(NativeDataStreamProvider dataStreamProvider) {
        this.dataStreamProvider = (NativeDataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
    }

    @Inject
    public void setDbi(@ForMetadata IDBI dbi) {
        this.dbi.set((IDBI)Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null"));
    }

    @Inject
    public void setSplitManager(NativeSplitManager splitManager) {
        this.splitManager.set((NativeSplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null"));
    }

    public String getName() {
        return "native";
    }

    public Connector create(String connectorId, Map<String, String> properties) {
        NativeSplitManager splitManager;
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        IDBI dbi = this.dbi.get();
        if (dbi != null) {
            builder.put(ConnectorMetadata.class, (Object)new NativeMetadata(connectorId, dbi));
        }
        if ((splitManager = this.splitManager.get()) != null) {
            builder.put(ConnectorSplitManager.class, (Object)splitManager);
        }
        builder.put(ConnectorDataStreamProvider.class, (Object)this.dataStreamProvider);
        builder.put(ConnectorHandleResolver.class, (Object)HANDLE_RESOLVER);
        return new StaticConnector((Map<Class<?>, ?>)builder.build());
    }
}

