/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.DataStreamManager;
import com.facebook.presto.split.RecordSetDataStreamProvider;
import com.facebook.presto.split.SplitManager;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class ConnectorManager {
    private final MetadataManager metadataManager;
    private final SplitManager splitManager;
    private final DataStreamManager dataStreamManager;
    private final HandleResolver handleResolver;
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    private final ConcurrentMap<String, Connector> connectors = new ConcurrentHashMap<String, Connector>();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, SplitManager splitManager, DataStreamManager dataStreamManager, HandleResolver handleResolver, Map<String, ConnectorFactory> connectorFactories, Map<String, Connector> globalConnectors) {
        this.metadataManager = metadataManager;
        this.splitManager = splitManager;
        this.dataStreamManager = dataStreamManager;
        this.handleResolver = handleResolver;
        this.connectorFactories.putAll(connectorFactories);
        for (Map.Entry<String, Connector> entry : globalConnectors.entrySet()) {
            this.addGlobalConnector(entry.getKey(), entry.getValue());
        }
    }

    public void addConnectorFactory(ConnectorFactory connectorFactory) {
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object[])new Object[]{connectorFactory.getName()});
    }

    public synchronized void createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)connectorName, (Object)"connectorName is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        String connectorId = catalogName;
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object[])new Object[]{connectorName});
        Connector connector = connectorFactory.create(connectorId, properties);
        this.connectors.put(connectorId, connector);
        this.addConnector(catalogName, connectorId, connector);
    }

    public void addGlobalConnector(String connectorId, Connector connector) {
        this.addConnector(null, connectorId, connector);
    }

    private void addConnector(@Nullable String catalogName, String connectorId, Connector connector) {
        ConnectorMetadata connectorMetadata = (ConnectorMetadata)connector.getService(ConnectorMetadata.class);
        Preconditions.checkState((connectorMetadata != null ? 1 : 0) != 0, (String)"Connector %s can not provide metadata", (Object[])new Object[]{connectorId});
        ConnectorSplitManager connectorSplitManager = (ConnectorSplitManager)connector.getService(ConnectorSplitManager.class);
        Preconditions.checkState((connectorSplitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object[])new Object[]{connectorId});
        ConnectorDataStreamProvider connectorDataStreamProvider = (ConnectorDataStreamProvider)connector.getService(ConnectorDataStreamProvider.class);
        if (connectorDataStreamProvider == null) {
            ConnectorRecordSetProvider connectorRecordSetProvider = (ConnectorRecordSetProvider)connector.getService(ConnectorRecordSetProvider.class);
            Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s does not have a data stream provider", (Object[])new Object[]{connectorId});
            connectorDataStreamProvider = new RecordSetDataStreamProvider(connectorRecordSetProvider);
        }
        ConnectorHandleResolver connectorHandleResolver = (ConnectorHandleResolver)connector.getService(ConnectorHandleResolver.class);
        if (catalogName != null) {
            this.metadataManager.addConnectorMetadata(catalogName, connectorMetadata);
        } else {
            this.metadataManager.addInternalSchemaMetadata(connectorMetadata);
        }
        this.handleResolver.addHandleResolver(connectorId, connectorHandleResolver);
        this.splitManager.addConnectorSplitManager(connectorSplitManager);
        this.dataStreamManager.addConnectorDataStreamProvider(connectorDataStreamProvider);
    }
}

