/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.debug;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.debug.DebugNode;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LineNumberNode
implements DebugNode {
    private final int lineNumber;
    private final LabelNode label = new LabelNode();

    public LineNumberNode(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        visitor.visitLineNumber(this.lineNumber, this.label.getLabel());
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("line", this.lineNumber).toString();
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitLineNumber(parent, this);
    }
}

