/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.ParameterizedType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DynamicClassLoader
extends ClassLoader {
    private final ConcurrentMap<ParameterizedType, byte[]> pendingClasses = new ConcurrentHashMap<ParameterizedType, byte[]>();

    public DynamicClassLoader() {
        this(null);
    }

    public DynamicClassLoader(ClassLoader parentClassLoader) {
        super(DynamicClassLoader.resolveClassLoader(parentClassLoader));
    }

    public Class<?> defineClass(String className, byte[] byteCode) {
        return super.defineClass(className, byteCode, 0, byteCode.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> defineClasses(Map<ParameterizedType, byte[]> newClasses) {
        Sets.SetView conflicts = Sets.intersection(this.pendingClasses.keySet(), newClasses.keySet());
        Preconditions.checkArgument((boolean)conflicts.isEmpty(), (String)"The classes %s have already been defined", (Object[])new Object[]{conflicts});
        this.pendingClasses.putAll(newClasses);
        try {
            HashMap classes = new HashMap();
            for (ParameterizedType type : newClasses.keySet()) {
                try {
                    Class<?> clazz = this.loadClass(type.getJavaClassName());
                    classes.put(type.getJavaClassName(), clazz);
                }
                catch (ClassNotFoundException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            HashMap hashMap = classes;
            return hashMap;
        }
        finally {
            this.pendingClasses.keySet().removeAll(newClasses.keySet());
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] byteCode = (byte[])this.pendingClasses.get(ParameterizedType.typeFromJavaClassName(name));
        if (byteCode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, byteCode);
    }

    private static ClassLoader resolveClassLoader(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (parentClassLoader == null) {
            parentClassLoader = DynamicClassLoader.class.getClassLoader();
        }
        if (parentClassLoader == null) {
            parentClassLoader = ClassLoader.getSystemClassLoader();
        }
        return parentClassLoader;
    }
}

