/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.List;

public class UncompressedTupleInfoSerde {
    public static int serialize(TupleInfo tupleInfo, SliceOutput sliceOutput) {
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
        sliceOutput.writeByte(tupleInfo.getFieldCount());
        int bytes = 1;
        for (TupleInfo.Type type : tupleInfo.getTypes()) {
            sliceOutput.writeByte(type.ordinal());
            ++bytes;
        }
        return bytes;
    }

    public static TupleInfo deserialize(SliceInput sliceInput) {
        Preconditions.checkNotNull((Object)sliceInput, (Object)"slice is null");
        int fieldCount = sliceInput.readUnsignedByte();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < fieldCount; ++i) {
            builder.add((Object)TupleInfo.Type.values()[sliceInput.readUnsignedByte()]);
        }
        return new TupleInfo((List<TupleInfo.Type>)builder.build());
    }
}

