/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class UncompressedSliceBlockCursor
implements BlockCursor {
    private final Slice slice;
    private final int positionCount;
    private int position;
    private int offset;
    private int size;

    public UncompressedSliceBlockCursor(int positionCount, Slice slice) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkNotNull((Object)positionCount, (Object)"positionCount is null");
        this.positionCount = positionCount;
        this.slice = slice;
        this.offset = 0;
        this.size = 0;
        this.position = -1;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    @Override
    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    @Override
    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"cursor is not valid");
    }

    @Override
    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        this.offset += this.size;
        this.size = this.slice.getInt(this.offset + 1);
        return true;
    }

    @Override
    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0, (Object)"Can't advance backwards");
        while (this.position < newPosition) {
            ++this.position;
            this.offset += this.size;
            this.size = this.slice.getInt(this.offset + 1);
        }
        return true;
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        int startOffset = this.offset + this.size;
        length = Math.min(length, this.getRemainingPositions());
        for (int i = 0; i < length; ++i) {
            ++this.position;
            this.offset += this.size;
            this.size = this.slice.getInt(this.offset + 1);
        }
        Slice newSlice = this.slice.slice(startOffset, this.offset + this.size - startOffset);
        return new UncompressedBlock(length, TupleInfo.SINGLE_VARBINARY, newSlice);
    }

    @Override
    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    @Override
    public Tuple getTuple() {
        this.checkReadablePosition();
        Slice copy = Slices.allocate((int)this.size);
        copy.setBytes(0, this.slice, this.offset, this.size);
        return new Tuple(copy, TupleInfo.SINGLE_VARBINARY);
    }

    @Override
    public boolean getBoolean(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(int field) {
        this.checkReadablePosition();
        Preconditions.checkElementIndex((int)0, (int)1, (String)"field");
        return this.slice.slice(this.offset + 4 + 1, this.size - 4 - 1);
    }

    @Override
    public boolean isNull(int field) {
        this.checkReadablePosition();
        Preconditions.checkElementIndex((int)0, (int)1, (String)"field");
        return this.slice.getByte(this.offset) != 0;
    }

    @Override
    public boolean currentTupleEquals(Tuple value) {
        this.checkReadablePosition();
        Slice tupleSlice = value.getTupleSlice();
        return this.slice.equals(this.offset, this.size, tupleSlice, 0, tupleSlice.length());
    }

    @Override
    public int getRawOffset() {
        return this.offset;
    }

    @Override
    public Slice getRawSlice() {
        return this.slice;
    }

    @Override
    public void appendTupleTo(BlockBuilder blockBuilder) {
        blockBuilder.appendTuple(this.slice, this.offset, this.size);
    }
}

