/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.snappy;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBooleanBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedDoubleBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedLongBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedSliceBlockCursor;
import com.facebook.presto.serde.SnappyBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import javax.annotation.concurrent.GuardedBy;
import org.iq80.snappy.Snappy;

public class SnappyBlock
implements Block {
    private final int positionCount;
    private final TupleInfo tupleInfo;
    private final Slice compressedSlice;
    @GuardedBy(value="this")
    private Slice uncompressedSlice = null;

    public SnappyBlock(int positionCount, TupleInfo tupleInfo, Slice compressedSlice) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        Preconditions.checkNotNull((Object)compressedSlice, (Object)"compressedSlice is null");
        this.tupleInfo = tupleInfo;
        this.compressedSlice = compressedSlice;
        this.positionCount = positionCount;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public Slice getCompressedSlice() {
        return this.compressedSlice;
    }

    public synchronized Slice getUncompressedSlice() {
        if (this.uncompressedSlice == null) {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])this.compressedSlice.getBytes(), (int)0);
            Preconditions.checkState((uncompressedLength > 0 ? 1 : 0) != 0, (Object)"Empty block encountered!");
            byte[] output = new byte[uncompressedLength];
            Snappy.uncompress((byte[])this.compressedSlice.getBytes(), (int)0, (int)this.compressedSlice.length(), (byte[])output, (int)0);
            this.uncompressedSlice = Slices.wrappedBuffer((byte[])output);
        }
        return this.uncompressedSlice;
    }

    public int getSliceOffset() {
        return 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.getUncompressedSlice().length(), DataSize.Unit.BYTE);
    }

    @Override
    public BlockCursor cursor() {
        if (this.tupleInfo.getFieldCount() == 1) {
            TupleInfo.Type type = this.tupleInfo.getTypes().get(0);
            if (type == TupleInfo.Type.BOOLEAN) {
                return new UncompressedBooleanBlockCursor(this.positionCount, this.getUncompressedSlice());
            }
            if (type == TupleInfo.Type.FIXED_INT_64) {
                return new UncompressedLongBlockCursor(this.positionCount, this.getUncompressedSlice());
            }
            if (type == TupleInfo.Type.DOUBLE) {
                return new UncompressedDoubleBlockCursor(this.positionCount, this.getUncompressedSlice());
            }
            if (type == TupleInfo.Type.VARIABLE_BINARY) {
                return new UncompressedSliceBlockCursor(this.positionCount, this.getUncompressedSlice());
            }
        }
        return new UncompressedBlockCursor(this.tupleInfo, this.positionCount, this.getUncompressedSlice());
    }

    @Override
    public SnappyBlockEncoding getEncoding() {
        return new SnappyBlockEncoding(this.tupleInfo);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return this.cursor().getRegionAndAdvance(length);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("tupleInfo", (Object)this.tupleInfo).add("compressedSlice", (Object)this.compressedSlice).toString();
    }
}

