/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.rle;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.rle.RunLengthEncodedBlock;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public final class RunLengthEncodedBlockCursor
implements BlockCursor {
    private final Tuple value;
    private final int positionCount;
    private int position = -1;

    public RunLengthEncodedBlockCursor(Tuple value, int positionCount) {
        this.value = value;
        this.positionCount = positionCount;
        this.position = -1;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.value.getTupleInfo();
    }

    @Override
    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    @Override
    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    @Override
    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"cursor is not valid");
    }

    @Override
    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0, (Object)"Can't advance backwards");
        this.position = newPosition;
        return true;
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        length = Math.min(length, this.getRemainingPositions());
        this.position += length;
        return new RunLengthEncodedBlock(this.value, length);
    }

    @Override
    public Tuple getTuple() {
        this.checkReadablePosition();
        return this.value;
    }

    @Override
    public boolean getBoolean(int field) {
        this.checkReadablePosition();
        return this.value.getBoolean(field);
    }

    @Override
    public long getLong(int field) {
        this.checkReadablePosition();
        return this.value.getLong(field);
    }

    @Override
    public double getDouble(int field) {
        this.checkReadablePosition();
        return this.value.getDouble(field);
    }

    @Override
    public Slice getSlice(int field) {
        this.checkReadablePosition();
        return this.value.getSlice(field);
    }

    @Override
    public boolean isNull(int field) {
        this.checkReadablePosition();
        return this.value.isNull(field);
    }

    @Override
    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    @Override
    public boolean currentTupleEquals(Tuple value) {
        this.checkReadablePosition();
        return this.value.equals(value);
    }

    @Override
    public int getRawOffset() {
        return 0;
    }

    @Override
    public Slice getRawSlice() {
        return this.value.getTupleSlice();
    }

    @Override
    public void appendTupleTo(BlockBuilder blockBuilder) {
        blockBuilder.append(this.value);
    }
}

