/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.dictionary.Dictionary;
import com.facebook.presto.block.dictionary.DictionaryEncodedBlockCursor;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.DictionaryBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;

public class DictionaryEncodedBlock
implements Block {
    private final Dictionary dictionary;
    private final Block idBlock;

    public DictionaryEncodedBlock(Dictionary dictionary, Block idBlock) {
        Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        Preconditions.checkNotNull((Object)idBlock, (Object)"block is null");
        Preconditions.checkArgument((boolean)idBlock.getTupleInfo().equals(TupleInfo.SINGLE_LONG), (Object)"block must contain tuples with a single long value");
        this.dictionary = dictionary;
        this.idBlock = idBlock;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.dictionary.getTupleInfo();
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public Block getIdBlock() {
        return this.idBlock;
    }

    @Override
    public int getPositionCount() {
        return this.idBlock.getPositionCount();
    }

    @Override
    public DataSize getDataSize() {
        return this.idBlock.getDataSize();
    }

    @Override
    public BlockEncoding getEncoding() {
        return new DictionaryBlockEncoding(this.dictionary, this.idBlock.getEncoding());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        return new DictionaryEncodedBlock(this.dictionary, this.idBlock.getRegion(positionOffset, length));
    }

    @Override
    public DictionaryEncodedBlockCursor cursor() {
        return new DictionaryEncodedBlockCursor(this.dictionary, this.idBlock.cursor());
    }
}

