/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;

public final class BlockIterables {
    private BlockIterables() {
    }

    public static BlockIterable createBlockIterable(Block firstBlock, Block ... otherBlocks) {
        TupleInfo tupleInfo = firstBlock.getTupleInfo();
        return new StaticBlockIterable(tupleInfo, (Iterable<Block>)ImmutableList.builder().add((Object)firstBlock).add((Object[])otherBlocks).build());
    }

    public static BlockIterable createBlockIterable(Iterable<? extends Block> blocks) {
        TupleInfo tupleInfo = ((Block)Iterables.get(blocks, (int)0)).getTupleInfo();
        return new StaticBlockIterable(tupleInfo, (Iterable<Block>)ImmutableList.copyOf(blocks));
    }

    public static BlockIterable createBlockIterable(TupleInfo tupleInfo, Iterable<? extends Block> blocks) {
        return new StaticBlockIterable(tupleInfo, (Iterable<Block>)ImmutableList.copyOf(blocks));
    }

    public static Optional<DataSize> getDataSize(BlockIterable ... blockIterables) {
        return BlockIterables.getDataSize((Iterable<? extends BlockIterable>)ImmutableList.copyOf((Object[])blockIterables));
    }

    public static Optional<DataSize> getDataSize(Iterable<? extends BlockIterable> blockIterables) {
        long dataSize = 0L;
        for (BlockIterable blockIterable : blockIterables) {
            if (!blockIterable.getDataSize().isPresent()) {
                return Optional.absent();
            }
            dataSize += ((DataSize)blockIterable.getDataSize().get()).toBytes();
        }
        return Optional.of((Object)new DataSize((double)dataSize, DataSize.Unit.BYTE));
    }

    public static Optional<Integer> getPositionCount(BlockIterable ... blockIterables) {
        return BlockIterables.getPositionCount((Iterable<? extends BlockIterable>)ImmutableList.copyOf((Object[])blockIterables));
    }

    public static Optional<Integer> getPositionCount(Iterable<? extends BlockIterable> blockIterables) {
        for (BlockIterable blockIterable : blockIterables) {
            if (blockIterable.getDataSize().isPresent()) continue;
            return Optional.absent();
        }
        return ((BlockIterable)Iterables.getFirst(blockIterables, null)).getPositionCount();
    }

    public static BlockIterable concat(BlockIterable ... blockIterables) {
        return new ConcatBlockIterable((Iterable)ImmutableList.copyOf((Object[])blockIterables));
    }

    public static BlockIterable concat(Iterable<? extends BlockIterable> blockIterables) {
        return new ConcatBlockIterable(blockIterables);
    }

    private static class ConcatBlockIterable
    implements BlockIterable {
        private final Iterable<? extends BlockIterable> blockIterables;
        private final TupleInfo tupleInfo;
        private final Optional<DataSize> dataSize;
        private final Optional<Integer> positionCount;

        private ConcatBlockIterable(Iterable<? extends BlockIterable> blockIterables) {
            this.blockIterables = blockIterables;
            this.dataSize = BlockIterables.getDataSize(blockIterables);
            this.positionCount = BlockIterables.getPositionCount(blockIterables);
            this.tupleInfo = blockIterables.iterator().next().getTupleInfo();
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.tupleInfo;
        }

        @Override
        public Optional<DataSize> getDataSize() {
            return this.dataSize;
        }

        @Override
        public Optional<Integer> getPositionCount() {
            return this.positionCount;
        }

        @Override
        public Iterator<Block> iterator() {
            return new AbstractIterator<Block>(){
                private final Iterator<? extends BlockIterable> blockIterables;
                private Iterator<Block> blocks;
                {
                    this.blockIterables = ConcatBlockIterable.this.blockIterables.iterator();
                }

                protected Block computeNext() {
                    while ((this.blocks == null || !this.blocks.hasNext()) && this.blockIterables.hasNext()) {
                        this.blocks = this.blockIterables.next().iterator();
                    }
                    if (this.blocks == null || !this.blocks.hasNext()) {
                        return (Block)this.endOfData();
                    }
                    UncompressedBlock block = (UncompressedBlock)this.blocks.next();
                    return block;
                }
            };
        }
    }

    private static class StaticBlockIterable
    implements BlockIterable {
        private final TupleInfo tupleInfo;
        private final List<Block> blocks;
        private final int positionCount;
        private final DataSize dataSize;

        public StaticBlockIterable(TupleInfo tupleInfo, Iterable<Block> blocks) {
            this.tupleInfo = (TupleInfo)Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
            this.blocks = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(blocks, (Object)"blocks is null")));
            long positionCount = 0L;
            long dataSize = 0L;
            for (Block block : this.blocks) {
                positionCount += (long)block.getPositionCount();
                dataSize += block.getDataSize().toBytes();
            }
            this.positionCount = Ints.checkedCast((long)positionCount);
            this.dataSize = new DataSize((double)dataSize, DataSize.Unit.BYTE);
        }

        @Override
        public TupleInfo getTupleInfo() {
            return this.tupleInfo;
        }

        @Override
        public Iterator<Block> iterator() {
            return this.blocks.iterator();
        }

        @Override
        public Optional<DataSize> getDataSize() {
            return Optional.of((Object)this.dataSize);
        }

        @Override
        public Optional<Integer> getPositionCount() {
            return Optional.of((Object)this.positionCount);
        }
    }
}

