/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionException;
import java.util.Arrays;

public class ZstdCodec
implements CompressionCodec {
    public static final String CODEC_NAME = "ZSTD";

    public String getAlgorithmName() {
        return CODEC_NAME;
    }

    public byte[] compress(byte[] bytes) throws CompressionException {
        ZstdCompressor compressor = new ZstdCompressor();
        byte[] compressed = new byte[compressor.maxCompressedLength(bytes.length)];
        int outputSize = compressor.compress(bytes, 0, bytes.length, compressed, 0, compressed.length);
        return Arrays.copyOfRange(compressed, 0, outputSize);
    }

    public byte[] decompress(byte[] bytes) throws CompressionException {
        byte[] output = new byte[Math.toIntExact(ZstdDecompressor.getDecompressedSize((byte[])bytes, (int)0, (int)bytes.length))];
        new ZstdDecompressor().decompress(bytes, 0, bytes.length, output, 0, output.length);
        return output;
    }
}

