/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class OidcDiscoveryConfig {
    private Duration discoveryTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private boolean userinfoEndpointEnabled = true;
    private Optional<String> accessTokenIssuer = Optional.empty();
    private Optional<String> authUrl = Optional.empty();
    private Optional<String> tokenUrl = Optional.empty();
    private Optional<String> jwksUrl = Optional.empty();
    private Optional<String> userinfoUrl = Optional.empty();

    @NotNull
    public Duration getDiscoveryTimeout() {
        return this.discoveryTimeout;
    }

    @Config(value="http-server.authentication.oauth2.oidc.discovery.timeout")
    @ConfigDescription(value="OpenID Connect discovery timeout")
    public OidcDiscoveryConfig setDiscoveryTimeout(Duration discoveryTimeout) {
        this.discoveryTimeout = discoveryTimeout;
        return this;
    }

    public boolean isUserinfoEndpointEnabled() {
        return this.userinfoEndpointEnabled;
    }

    @Config(value="http-server.authentication.oauth2.oidc.use-userinfo-endpoint")
    @ConfigDescription(value="Use userinfo endpoint from OpenID connect metadata document")
    public OidcDiscoveryConfig setUserinfoEndpointEnabled(boolean userinfoEndpointEnabled) {
        this.userinfoEndpointEnabled = userinfoEndpointEnabled;
        return this;
    }

    @NotNull
    @Deprecated
    public Optional<String> getAccessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    @Config(value="http-server.authentication.oauth2.access-token-issuer")
    @ConfigDescription(value="The required issuer for access tokens")
    @Deprecated
    public OidcDiscoveryConfig setAccessTokenIssuer(String accessTokenIssuer) {
        this.accessTokenIssuer = Optional.ofNullable(accessTokenIssuer);
        return this;
    }

    @NotNull
    @Deprecated
    public Optional<String> getAuthUrl() {
        return this.authUrl;
    }

    @Config(value="http-server.authentication.oauth2.auth-url")
    @ConfigDescription(value="URL of the authorization server's authorization endpoint")
    @Deprecated
    public OidcDiscoveryConfig setAuthUrl(String authUrl) {
        this.authUrl = Optional.ofNullable(authUrl);
        return this;
    }

    @NotNull
    @Deprecated
    public Optional<String> getTokenUrl() {
        return this.tokenUrl;
    }

    @Config(value="http-server.authentication.oauth2.token-url")
    @ConfigDescription(value="URL of the authorization server's token endpoint")
    @Deprecated
    public OidcDiscoveryConfig setTokenUrl(String tokenUrl) {
        this.tokenUrl = Optional.ofNullable(tokenUrl);
        return this;
    }

    @NotNull
    @Deprecated
    public Optional<String> getJwksUrl() {
        return this.jwksUrl;
    }

    @Config(value="http-server.authentication.oauth2.jwks-url")
    @ConfigDescription(value="URL of the authorization server's JWKS (JSON Web Key Set) endpoint")
    @Deprecated
    public OidcDiscoveryConfig setJwksUrl(String jwksUrl) {
        this.jwksUrl = Optional.ofNullable(jwksUrl);
        return this;
    }

    @NotNull
    @Deprecated
    public Optional<String> getUserinfoUrl() {
        return this.userinfoUrl;
    }

    @Config(value="http-server.authentication.oauth2.userinfo-url")
    @ConfigDescription(value="URL of the userinfo endpoint")
    @Deprecated
    public OidcDiscoveryConfig setUserinfoUrl(String userinfoUrl) {
        this.userinfoUrl = Optional.ofNullable(userinfoUrl);
        return this;
    }
}

