/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.security.oauth2.NimbusHttpClient;
import com.facebook.presto.server.security.oauth2.OAuth2Config;
import com.facebook.presto.server.security.oauth2.OAuth2ServerConfigProvider;
import com.facebook.presto.server.security.oauth2.OidcDiscoveryConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderConfigurationRequest;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;

public class OidcDiscovery
implements OAuth2ServerConfigProvider {
    private static final Logger LOG = Logger.get(OidcDiscovery.class);
    private static final ObjectMapper OBJECT_MAPPER = new JsonObjectMapperProvider().get();
    private final Issuer issuer;
    private final Duration discoveryTimeout;
    private final boolean userinfoEndpointEnabled;
    private final Optional<String> accessTokenIssuer;
    private final Optional<String> authUrl;
    private final Optional<String> tokenUrl;
    private final Optional<String> jwksUrl;
    private final Optional<String> userinfoUrl;
    private final NimbusHttpClient httpClient;

    @Inject
    public OidcDiscovery(OAuth2Config oauthConfig, OidcDiscoveryConfig oidcConfig, NimbusHttpClient httpClient) {
        Objects.requireNonNull(oauthConfig, "oauthConfig is null");
        this.issuer = new Issuer(Objects.requireNonNull(oauthConfig.getIssuer(), "issuer is null"));
        Objects.requireNonNull(oidcConfig, "oidcConfig is null");
        this.userinfoEndpointEnabled = oidcConfig.isUserinfoEndpointEnabled();
        this.discoveryTimeout = Duration.ofMillis(Objects.requireNonNull(oidcConfig.getDiscoveryTimeout(), "discoveryTimeout is null").toMillis());
        this.accessTokenIssuer = Objects.requireNonNull(oidcConfig.getAccessTokenIssuer(), "accessTokenIssuer is null");
        this.authUrl = Objects.requireNonNull(oidcConfig.getAuthUrl(), "authUrl is null");
        this.tokenUrl = Objects.requireNonNull(oidcConfig.getTokenUrl(), "tokenUrl is null");
        this.jwksUrl = Objects.requireNonNull(oidcConfig.getJwksUrl(), "jwksUrl is null");
        this.userinfoUrl = Objects.requireNonNull(oidcConfig.getUserinfoUrl(), "userinfoUrl is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    @Override
    public OAuth2ServerConfigProvider.OAuth2ServerConfig get() {
        return (OAuth2ServerConfigProvider.OAuth2ServerConfig)Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxAttempts(-1).withMaxDuration(this.discoveryTimeout).withDelay(Duration.ofSeconds(1L)).abortOn(IllegalStateException.class).onFailedAttempt(attempt -> LOG.debug("OpenID Connect Metadata read failed: %s", new Object[]{attempt.getLastFailure()}))}).get(() -> this.httpClient.execute((Request)new OIDCProviderConfigurationRequest(this.issuer), this::parseConfigurationResponse));
    }

    private OAuth2ServerConfigProvider.OAuth2ServerConfig parseConfigurationResponse(HTTPResponse response) throws ParseException {
        int statusCode = response.getStatusCode();
        if (statusCode != HttpStatus.OK.code()) {
            if (statusCode < 400 || statusCode >= 500 || statusCode == HttpStatus.REQUEST_TIMEOUT.code() || statusCode == HttpStatus.TOO_MANY_REQUESTS.code()) {
                throw new RuntimeException("Invalid response from OpenID Metadata endpoint: " + statusCode);
            }
            throw new IllegalStateException(String.format("Invalid response from OpenID Metadata endpoint. Expected response code to be %s, but was %s", HttpStatus.OK.code(), statusCode));
        }
        return this.readConfiguration(response.getContent());
    }

    private OAuth2ServerConfigProvider.OAuth2ServerConfig readConfiguration(String body) throws ParseException {
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)body);
        OidcDiscovery.checkMetadataState(this.issuer.equals((Object)metadata.getIssuer()), "The value of the \"issuer\" claim in Metadata document different than the Issuer URL used for the Configuration Request.", new String[0]);
        try {
            JsonNode metadataJson = OBJECT_MAPPER.readTree(body);
            Optional<Object> userinfoEndpoint = this.userinfoEndpointEnabled ? OidcDiscovery.getOptionalField("userinfo_endpoint", Optional.ofNullable(metadata.getUserInfoEndpointURI()).map(URI::toString), "http-server.authentication.oauth2.userinfo-url", this.userinfoUrl) : Optional.empty();
            return new OAuth2ServerConfigProvider.OAuth2ServerConfig(OidcDiscovery.getOptionalField("access_token_issuer", Optional.ofNullable(metadataJson.get("access_token_issuer")).map(JsonNode::textValue), "http-server.authentication.oauth2.access-token-issuer", this.accessTokenIssuer), OidcDiscovery.getRequiredField("authorization_endpoint", metadata.getAuthorizationEndpointURI(), "http-server.authentication.oauth2.auth-url", this.authUrl), OidcDiscovery.getRequiredField("token_endpoint", metadata.getTokenEndpointURI(), "http-server.authentication.oauth2.token-url", this.tokenUrl), OidcDiscovery.getRequiredField("jwks_uri", metadata.getJWKSetURI(), "http-server.authentication.oauth2.jwks-url", this.jwksUrl), userinfoEndpoint.map(URI::create));
        }
        catch (JsonProcessingException e) {
            throw new ParseException("Invalid JSON value", (Throwable)e);
        }
    }

    private static URI getRequiredField(String metadataField, URI metadataValue, String configurationField, Optional<String> configurationValue) {
        Optional<String> uri = OidcDiscovery.getOptionalField(metadataField, Optional.ofNullable(metadataValue).map(URI::toString), configurationField, configurationValue);
        OidcDiscovery.checkMetadataState(uri.isPresent(), "Missing required \"%s\" property.", metadataField);
        return URI.create(uri.get());
    }

    private static Optional<String> getOptionalField(String metadataField, Optional<String> metadataValue, String configurationField, Optional<String> configurationValue) {
        if (configurationValue.isPresent()) {
            if (!configurationValue.equals(metadataValue)) {
                LOG.warn("Overriding \"%s=%s\" from OpenID metadata document with value \"%s=%s\" defined in configuration", new Object[]{metadataField, metadataValue.orElse(""), configurationField, configurationValue.orElse("")});
            }
            return configurationValue;
        }
        return metadataValue;
    }

    private static void checkMetadataState(boolean expression, String additionalMessage, String ... additionalMessageArgs) {
        Preconditions.checkState((boolean)expression, (String)("Invalid response from OpenID Metadata endpoint. " + additionalMessage), (Object[])additionalMessageArgs);
    }
}

