/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.security.AuthenticationFilter;
import com.facebook.presto.server.security.WebUiAuthenticationManager;
import com.facebook.presto.server.security.oauth2.ChallengeFailedException;
import com.facebook.presto.server.security.oauth2.ForRefreshTokens;
import com.facebook.presto.server.security.oauth2.NonceCookie;
import com.facebook.presto.server.security.oauth2.OAuth2Authenticator;
import com.facebook.presto.server.security.oauth2.OAuth2Client;
import com.facebook.presto.server.security.oauth2.OAuth2Service;
import com.facebook.presto.server.security.oauth2.OAuth2Utils;
import com.facebook.presto.server.security.oauth2.OAuthWebUiCookie;
import com.facebook.presto.server.security.oauth2.TokenPairSerializer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class OAuth2WebUiAuthenticationManager
implements WebUiAuthenticationManager {
    private static final Logger logger = Logger.get(OAuth2WebUiAuthenticationManager.class);
    private final OAuth2Service oAuth2Service;
    private final OAuth2Authenticator oAuth2Authenticator;
    private final TokenPairSerializer tokenPairSerializer;
    private final OAuth2Client client;
    private final Optional<Duration> tokenExpiration;

    @Inject
    public OAuth2WebUiAuthenticationManager(OAuth2Service oAuth2Service, OAuth2Authenticator oAuth2Authenticator, TokenPairSerializer tokenPairSerializer, OAuth2Client client, @ForRefreshTokens Optional<Duration> tokenExpiration) {
        this.oAuth2Service = Objects.requireNonNull(oAuth2Service, "oauth2Service is null");
        this.oAuth2Authenticator = Objects.requireNonNull(oAuth2Authenticator, "oauth2Authenticator is null");
        this.tokenPairSerializer = Objects.requireNonNull(tokenPairSerializer, "tokenPairSerializer is null");
        this.client = Objects.requireNonNull(client, "oauth2Client is null");
        this.tokenExpiration = Objects.requireNonNull(tokenExpiration, "tokenExpiration is null");
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain nextFilter) throws IOException, ServletException {
        try {
            Principal principal = this.oAuth2Authenticator.authenticate(request);
            nextFilter.doFilter(AuthenticationFilter.withPrincipal(request, principal), (ServletResponse)response);
        }
        catch (AuthenticationException e) {
            this.needAuthentication(request, response);
        }
    }

    private Optional<TokenPairSerializer.TokenPair> getTokenPair(HttpServletRequest request) {
        try {
            Optional<String> token = OAuth2Authenticator.extractTokenFromCookie(request);
            if (token.isPresent()) {
                return Optional.ofNullable(this.tokenPairSerializer.deserialize(token.get()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Exception occurred during token pair deserialization");
            return Optional.empty();
        }
    }

    private void needAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<TokenPairSerializer.TokenPair> tokenPair = this.getTokenPair(request);
        Optional refreshToken = tokenPair.flatMap(TokenPairSerializer.TokenPair::getRefreshToken);
        if (refreshToken.isPresent()) {
            try {
                OAuth2Client.Response refreshRes = this.client.refreshTokens((String)refreshToken.get());
                String serializeToken = this.tokenPairSerializer.serialize(TokenPairSerializer.TokenPair.fromOAuth2Response(refreshRes));
                UriBuilder builder = OAuth2Utils.getSchemeUriBuilder(request);
                Cookie newCookie = NonceCookie.toServletCookie(OAuthWebUiCookie.create(serializeToken, this.tokenExpiration.map(expiration -> Instant.now().plus((TemporalAmount)expiration)).orElse(refreshRes.getExpiration())));
                response.addCookie(newCookie);
                response.sendRedirect(builder.build(new Object[0]).toString());
            }
            catch (ChallengeFailedException e) {
                logger.error((Throwable)e, "Token refresh challenge has failed");
                this.startOauth2Challenge(request, response);
            }
        } else {
            this.startOauth2Challenge(request, response);
        }
    }

    private void startOauth2Challenge(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UriBuilder builder = OAuth2Utils.getSchemeUriBuilder(request);
        this.oAuth2Service.startOAuth2Challenge(builder.build(new Object[0]).resolve("/oauth2/callback"), Optional.empty(), response);
    }
}

