/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class OAuth2Utils {
    private OAuth2Utils() {
    }

    public static UriBuilder getSchemeUriBuilder(HttpServletRequest request) {
        Optional<String> forwardedProto = Optional.ofNullable(request.getHeader("X-Forwarded-Proto"));
        UriBuilder builder = UriBuilder.fromUri((String)OAuth2Utils.getFullRequestURL(request));
        if (forwardedProto.isPresent()) {
            builder.scheme(forwardedProto.get());
        } else {
            builder.scheme(request.getScheme());
        }
        return builder;
    }

    public static Optional<String> getLastURLParameter(MultivaluedMap<String, String> queryParams) {
        Optional<Map.Entry> lastUrl = queryParams.entrySet().stream().filter(qp -> ((String)qp.getKey()).equals("lastURL")).findFirst();
        if (lastUrl.isPresent() && ((List)lastUrl.get().getValue()).size() > 0) {
            return Optional.ofNullable((String)((List)lastUrl.get().getValue()).get(0));
        }
        return Optional.empty();
    }

    public static String getFullRequestURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(request.getRequestURL());
        String queryString = request.getQueryString();
        return queryString == null ? requestURL.toString() : requestURL.append("?").append(queryString).toString();
    }
}

