/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.presto.server.security.oauth2.ForOAuth2;
import com.facebook.presto.server.security.oauth2.ForRefreshTokens;
import com.facebook.presto.server.security.oauth2.JweTokenSerializerModule;
import com.facebook.presto.server.security.oauth2.NimbusAirliftHttpClient;
import com.facebook.presto.server.security.oauth2.NimbusHttpClient;
import com.facebook.presto.server.security.oauth2.NimbusOAuth2Client;
import com.facebook.presto.server.security.oauth2.OAuth2CallbackResource;
import com.facebook.presto.server.security.oauth2.OAuth2Client;
import com.facebook.presto.server.security.oauth2.OAuth2Config;
import com.facebook.presto.server.security.oauth2.OAuth2ServerConfigProvider;
import com.facebook.presto.server.security.oauth2.OAuth2Service;
import com.facebook.presto.server.security.oauth2.OAuth2TokenExchange;
import com.facebook.presto.server.security.oauth2.OAuth2TokenHandler;
import com.facebook.presto.server.security.oauth2.OidcDiscovery;
import com.facebook.presto.server.security.oauth2.OidcDiscoveryConfig;
import com.facebook.presto.server.security.oauth2.StaticConfigurationProvider;
import com.facebook.presto.server.security.oauth2.StaticOAuth2ServerConfiguration;
import com.facebook.presto.server.security.oauth2.TokenPairSerializer;
import com.facebook.presto.server.security.oauth2.TokenRefresher;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import java.time.Duration;

public class OAuth2ServiceModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(OAuth2CallbackResource.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OAuth2Config.class);
        binder.bind(OAuth2Service.class).in(Scopes.SINGLETON);
        binder.bind(OAuth2TokenHandler.class).to(OAuth2TokenExchange.class).in(Scopes.SINGLETON);
        binder.bind(NimbusHttpClient.class).to(NimbusAirliftHttpClient.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setDefault().to(NimbusOAuth2Client.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.installModuleIf(OAuth2Config.class, OAuth2Config::isEnableDiscovery, this::bindOidcDiscovery, this::bindStaticConfiguration));
        this.install(ConditionalModule.installModuleIf(OAuth2Config.class, OAuth2Config::isEnableRefreshTokens, this::enableRefreshTokens, this::disableRefreshTokens));
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("oauth2-jwk", ForOAuth2.class).withConfigDefaults(config -> config.setKeyStorePath(null).setKeyStorePassword(null).setTrustStorePath(null).setTrustStorePassword(null));
    }

    private void enableRefreshTokens(Binder binder) {
        this.install((Module)new JweTokenSerializerModule());
    }

    private void disableRefreshTokens(Binder binder) {
        binder.bind(TokenPairSerializer.class).toInstance((Object)TokenPairSerializer.ACCESS_TOKEN_ONLY_SERIALIZER);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Duration.class, ForRefreshTokens.class));
    }

    @Singleton
    @Provides
    @Inject
    public TokenRefresher getTokenRefresher(TokenPairSerializer tokenAssembler, OAuth2TokenHandler tokenHandler, OAuth2Client oAuth2Client) {
        return new TokenRefresher(tokenAssembler, tokenHandler, oAuth2Client);
    }

    private void bindStaticConfiguration(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticOAuth2ServerConfiguration.class);
        binder.bind(OAuth2ServerConfigProvider.class).to(StaticConfigurationProvider.class).in(Scopes.SINGLETON);
    }

    private void bindOidcDiscovery(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(OidcDiscoveryConfig.class);
        binder.bind(OAuth2ServerConfigProvider.class).to(OidcDiscovery.class).in(Scopes.SINGLETON);
    }

    public int hashCode() {
        return OAuth2ServiceModule.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OAuth2ServiceModule;
    }
}

