/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.security.oauth2.NonceCookie;
import com.facebook.presto.server.security.oauth2.OAuth2Service;
import com.facebook.presto.server.security.oauth2.OAuth2Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Objects;
import javax.inject.Inject;

@Path(value="/oauth2/callback")
public class OAuth2CallbackResource {
    private static final Logger LOG = Logger.get(OAuth2CallbackResource.class);
    public static final String CALLBACK_ENDPOINT = "/oauth2/callback";
    private final OAuth2Service service;

    @Inject
    public OAuth2CallbackResource(OAuth2Service service) {
        this.service = Objects.requireNonNull(service, "service is null");
    }

    @GET
    @Produces(value={"text/html"})
    public Response callback(@QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription, @QueryParam(value="error_uri") String errorUri, @CookieParam(value="__Secure-Presto-Nonce") Cookie nonce, @Context HttpServletRequest request) {
        if (error != null) {
            return this.service.handleOAuth2Error(state, error, errorDescription, errorUri);
        }
        try {
            Objects.requireNonNull(state, "state is null");
            Objects.requireNonNull(code, "code is null");
            UriBuilder builder = OAuth2Utils.getSchemeUriBuilder(request);
            return this.service.finishOAuth2Challenge(state, code, builder.build(new Object[0]).resolve(CALLBACK_ENDPOINT), NonceCookie.read(nonce), request);
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e, "Authentication response could not be verified: state=%s", new Object[]{state});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cookie(new NewCookie[]{NonceCookie.delete()}).entity((Object)this.service.getInternalFailureHtml("Authentication response could not be verified")).build();
        }
    }
}

