/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security.oauth2;

import com.google.common.base.Predicates;
import jakarta.servlet.http.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class NonceCookie {
    public static final String NONCE_COOKIE = "__Secure-Presto-Nonce";

    private NonceCookie() {
    }

    public static NewCookie create(String nonce, Instant tokenExpiration) {
        return new NewCookie(NONCE_COOKIE, nonce, "/oauth2/callback", null, 1, null, -1, Date.from(tokenExpiration), true, true);
    }

    public static Cookie createServletCookie(String nonce, Instant tokenExpiration) {
        return NonceCookie.toServletCookie(NonceCookie.create(nonce, tokenExpiration));
    }

    public static Cookie toServletCookie(NewCookie cookie) {
        Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
        servletCookie.setPath(cookie.getPath());
        servletCookie.setMaxAge(cookie.getMaxAge());
        servletCookie.setSecure(cookie.isSecure());
        servletCookie.setHttpOnly(cookie.isHttpOnly());
        return servletCookie;
    }

    public static Optional<String> read(jakarta.ws.rs.core.Cookie cookie) {
        return Optional.ofNullable(cookie).map(jakarta.ws.rs.core.Cookie::getValue).filter((Predicate<String>)Predicates.not(StringUtils::isBlank));
    }

    public static NewCookie delete() {
        return new NewCookie(NONCE_COOKIE, "delete", "/oauth2/callback", null, 1, null, 0, null, true, true);
    }
}

