/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.spi.security.AuthorizedIdentity;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;

public class ServletSecurityUtils {
    public static final String AUTHORIZED_IDENTITY_ATTRIBUTE = "presto.authorized-identity";

    private ServletSecurityUtils() {
    }

    public static void setAuthorizedIdentity(HttpServletRequest servletRequest, AuthorizedIdentity authorizedIdentity) {
        servletRequest.setAttribute(AUTHORIZED_IDENTITY_ATTRIBUTE, (Object)authorizedIdentity);
    }

    public static Optional<AuthorizedIdentity> authorizedIdentity(HttpServletRequest servletRequest) {
        return Optional.ofNullable((AuthorizedIdentity)servletRequest.getAttribute(AUTHORIZED_IDENTITY_ATTRIBUTE));
    }
}

