/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.CertificateAuthenticator;
import com.facebook.airlift.http.server.ConfigurationBasedAuthorizer;
import com.facebook.airlift.http.server.ConfigurationBasedAuthorizerConfig;
import com.facebook.airlift.http.server.KerberosAuthenticator;
import com.facebook.airlift.http.server.KerberosConfig;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.presto.server.security.AuthenticationFilter;
import com.facebook.presto.server.security.CustomPrestoAuthenticator;
import com.facebook.presto.server.security.DefaultWebUiAuthenticationManager;
import com.facebook.presto.server.security.JsonWebTokenAuthenticator;
import com.facebook.presto.server.security.JsonWebTokenConfig;
import com.facebook.presto.server.security.PasswordAuthenticator;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.PrestoAuthenticatorManager;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.server.security.WebUiAuthenticationManager;
import com.facebook.presto.server.security.oauth2.OAuth2AuthenticationSupportModule;
import com.facebook.presto.server.security.oauth2.OAuth2Authenticator;
import com.facebook.presto.server.security.oauth2.OAuth2Config;
import com.facebook.presto.server.security.oauth2.OAuth2WebUiAuthenticationManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import jakarta.servlet.Filter;
import java.util.List;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, WebUiAuthenticationManager.class).setDefault().to(DefaultWebUiAuthenticationManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(AuthenticationFilter.class).in(Scopes.SINGLETON);
        binder.bind(PasswordAuthenticatorManager.class).in(Scopes.SINGLETON);
        binder.bind(PrestoAuthenticatorManager.class).in(Scopes.SINGLETON);
        List authTypes = ((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getAuthenticationTypes();
        Multibinder authBinder = Multibinder.newSetBinder((Binder)binder, Authenticator.class);
        for (SecurityConfig.AuthenticationType authType : authTypes) {
            if (authType == SecurityConfig.AuthenticationType.CERTIFICATE) {
                authBinder.addBinding().to(CertificateAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.KERBEROS) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
                authBinder.addBinding().to(KerberosAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.PASSWORD) {
                authBinder.addBinding().to(PasswordAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.JWT) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(JsonWebTokenConfig.class);
                authBinder.addBinding().to(JsonWebTokenAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.OAUTH2) {
                OptionalBinder.newOptionalBinder((Binder)binder, WebUiAuthenticationManager.class).setBinding().to(OAuth2WebUiAuthenticationManager.class).in(Scopes.SINGLETON);
                this.install((Module)new OAuth2AuthenticationSupportModule());
                binder.bind(OAuth2Authenticator.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(OAuth2Config.class);
                authBinder.addBinding().to(OAuth2Authenticator.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(ConfigurationBasedAuthorizerConfig.class);
                binder.bind(Authorizer.class).to(ConfigurationBasedAuthorizer.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType == SecurityConfig.AuthenticationType.CUSTOM) {
                authBinder.addBinding().to(CustomPrestoAuthenticator.class).in(Scopes.SINGLETON);
                continue;
            }
            if (authType != SecurityConfig.AuthenticationType.TEST_EXTERNAL) {
                throw new AssertionError((Object)("Unhandled auth type: " + String.valueOf(authType)));
            }
        }
    }
}

