/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

public class PasswordAuthenticator
implements Authenticator {
    private final PasswordAuthenticatorManager authenticatorManager;

    @Inject
    public PasswordAuthenticator(PasswordAuthenticatorManager authenticatorManager) {
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
        authenticatorManager.setRequired();
    }

    public Principal authenticate(HttpServletRequest request) throws AuthenticationException {
        String header = Strings.nullToEmpty((String)request.getHeader("Authorization"));
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("basic")) {
            throw PasswordAuthenticator.needAuthentication(null);
        }
        String credentials = PasswordAuthenticator.decodeCredentials(header.substring(space + 1).trim());
        List parts = Splitter.on((char)':').limit(2).splitToList((CharSequence)credentials);
        if (parts.size() != 2 || parts.stream().anyMatch(String::isEmpty)) {
            throw new AuthenticationException("Malformed decoded credentials");
        }
        String user = (String)parts.get(0);
        String password = (String)parts.get(1);
        try {
            return this.authenticatorManager.getAuthenticator().createAuthenticatedPrincipal(user, password);
        }
        catch (AccessDeniedException e) {
            throw PasswordAuthenticator.needAuthentication(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    private static String decodeCredentials(String credentials) throws AuthenticationException {
        try {
            return new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException("Invalid base64 encoded credentials");
        }
    }

    private static AuthenticationException needAuthentication(String message) {
        return new AuthenticationException(message, "Basic realm=\"Presto\"");
    }
}

