/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.server.InternalAuthenticationManager;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@Provider
public class InternalAuthenticationFilter
implements ContainerRequestFilter {
    private final InternalAuthenticationManager internalAuthenticationManager;
    private Optional<Principal> principal = Optional.empty();
    @Context
    ResourceInfo resourceInfo;

    @Inject
    public InternalAuthenticationFilter(InternalAuthenticationManager internalAuthenticationManager) {
        this.internalAuthenticationManager = Objects.requireNonNull(internalAuthenticationManager, "internalAuthenticationManager is null");
    }

    public InternalAuthenticationFilter(InternalAuthenticationManager internalAuthenticationManager, ResourceInfo resourceInfo) {
        this.internalAuthenticationManager = Objects.requireNonNull(internalAuthenticationManager, "internalAuthenticationManager is null");
        this.resourceInfo = Objects.requireNonNull(resourceInfo, "resourceInfo is null");
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public void filter(ContainerRequestContext context) {
        if (this.internalAuthenticationManager.isInternalRequest(context) || this.internalAuthenticationManager.isInternalJwtEnabled() && InternalAuthenticationFilter.isAccessingInternalEndpoint(this.resourceInfo)) {
            Principal authenticatedPrincipal = this.internalAuthenticationManager.authenticateInternalRequest(context);
            if (authenticatedPrincipal == null) {
                Response.ResponseBuilder responseBuilder = Response.serverError();
                responseBuilder.status(401, "Unauthorized");
                context.abortWith(responseBuilder.build());
            } else {
                this.principal = Optional.of(authenticatedPrincipal);
            }
        }
    }

    private static boolean isAccessingInternalEndpoint(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            Class resourceClass = resourceInfo.getResourceClass();
            Method resourceMethod = resourceInfo.getResourceMethod();
            if (resourceClass != null && resourceClass.isAnnotationPresent(RolesAllowed.class) && Arrays.asList(resourceClass.getAnnotation(RolesAllowed.class).value()).contains("internal") || resourceMethod != null && resourceMethod.isAnnotationPresent(RolesAllowed.class) && Arrays.asList(resourceMethod.getAnnotation(RolesAllowed.class).value()).contains("internal")) {
                return true;
            }
        }
        return false;
    }
}

