/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.security.PrestoAuthenticatorManager;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.AuthenticatorNotApplicableException;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomPrestoAuthenticator
implements Authenticator {
    private static final Logger log = Logger.get(CustomPrestoAuthenticator.class);
    private PrestoAuthenticatorManager authenticatorManager;

    @Inject
    public CustomPrestoAuthenticator(PrestoAuthenticatorManager authenticatorManager) {
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
    }

    public Principal authenticate(HttpServletRequest request) throws AuthenticationException {
        try {
            Map<String, List<String>> headers = this.getHeadersMap(request);
            return this.authenticatorManager.getAuthenticator().createAuthenticatedPrincipal(headers);
        }
        catch (AuthenticatorNotApplicableException e) {
            log.debug((Throwable)e, e.getMessage());
            throw CustomPrestoAuthenticator.needAuthentication();
        }
        catch (AccessDeniedException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    private static AuthenticationException needAuthentication() {
        return new AuthenticationException(null);
    }

    private Map<String, List<String>> getHeadersMap(HttpServletRequest request) {
        return (Map)Collections.list(request.getHeaderNames()).stream().collect(ImmutableMap.toImmutableMap(headerName -> headerName, headerName -> Collections.list(request.getHeaders(headerName))));
    }
}

