/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.units.Duration;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ReactorNettyHttpClientConfig {
    private boolean reactorNettyHttpClientEnabled;
    private boolean httpsEnabled;
    private int minConnections = 50;
    private int maxConnections = 100;
    private int maxStreamPerChannel = 100;
    private int selectorThreadCount = Runtime.getRuntime().availableProcessors();
    private int eventLoopThreadCount = Runtime.getRuntime().availableProcessors();
    private Duration connectTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration requestTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private Optional<String> cipherSuites = Optional.empty();

    public boolean isReactorNettyHttpClientEnabled() {
        return this.reactorNettyHttpClientEnabled;
    }

    @Config(value="reactor.netty-http-client-enabled")
    @ConfigDescription(value="Enable reactor netty client for http communication between coordinator and worker")
    public ReactorNettyHttpClientConfig setReactorNettyHttpClientEnabled(boolean reactorNettyHttpClientEnabled) {
        this.reactorNettyHttpClientEnabled = reactorNettyHttpClientEnabled;
        return this;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Config(value="reactor.https-enabled")
    public ReactorNettyHttpClientConfig setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    @Min(value=10L)
    @Config(value="reactor.min-connections")
    @ConfigDescription(value="Min number of connections in the pool used by the netty http2 client to talk to the workers")
    public @Min(value=10L) ReactorNettyHttpClientConfig setMinConnections(int minConnections) {
        this.minConnections = minConnections;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Min(value=10L)
    @Config(value="reactor.max-connections")
    @ConfigDescription(value="Max total number of connections in the pool used by the netty client to talk to the workers")
    public @Min(value=10L) ReactorNettyHttpClientConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getMaxStreamPerChannel() {
        return this.maxStreamPerChannel;
    }

    @Config(value="reactor.max-stream-per-channel")
    @ConfigDescription(value="Max number of streams per single tcp connection between coordinator and worker")
    public ReactorNettyHttpClientConfig setMaxStreamPerChannel(int maxStreamPerChannel) {
        this.maxStreamPerChannel = maxStreamPerChannel;
        return this;
    }

    public int getSelectorThreadCount() {
        return this.selectorThreadCount;
    }

    @Config(value="reactor.selector-thread-count")
    @ConfigDescription(value="Number of select threads used by netty to handle the http messages")
    public ReactorNettyHttpClientConfig setSelectorThreadCount(int selectorThreadCount) {
        this.selectorThreadCount = selectorThreadCount;
        return this;
    }

    public int getEventLoopThreadCount() {
        return this.eventLoopThreadCount;
    }

    @Config(value="reactor.event-loop-thread-count")
    @ConfigDescription(value="Number of event loop threads used by netty to handle the http messages")
    public ReactorNettyHttpClientConfig setEventLoopThreadCount(int eventLoopThreadCount) {
        this.eventLoopThreadCount = eventLoopThreadCount;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="reactor.connect-timeout")
    public ReactorNettyHttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="reactor.request-timeout")
    public ReactorNettyHttpClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="reactor.keystore-path")
    public ReactorNettyHttpClientConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="reactor.keystore-password")
    public ReactorNettyHttpClientConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="reactor.truststore-path")
    public ReactorNettyHttpClientConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public Optional<String> getCipherSuites() {
        return this.cipherSuites;
    }

    @Config(value="reactor.cipher-suites")
    public ReactorNettyHttpClientConfig setCipherSuites(String cipherSuites) {
        this.cipherSuites = Optional.ofNullable(cipherSuites);
        return this;
    }
}

