/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.RequestStats;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.security.pem.PemReader;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.server.remotetask.ReactorNettyHttpClientConfig;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.Epoll;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import reactor.core.Disposable;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.Http2AllocationStrategy;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorNettyHttpClient
implements HttpClient,
Closeable {
    private static final Logger log = Logger.get(ReactorNettyHttpClient.class);
    private static final HeaderName CONTENT_TYPE_HEADER_NAME = HeaderName.of((String)"Content-Type");
    private static final HeaderName CONTENT_LENGTH_HEADER_NAME = HeaderName.of((String)"Content-Length");
    private final Duration requestTimeout;
    private reactor.netty.http.client.HttpClient httpClient;

    @Inject
    public ReactorNettyHttpClient(ReactorNettyHttpClientConfig config) {
        SslContext sslContext = null;
        if (config.isHttpsEnabled()) {
            try {
                File keyFile = new File(config.getKeyStorePath());
                File trustCertificateFile = new File(config.getTrustStorePath());
                if (!Files.exists(keyFile.toPath(), new LinkOption[0]) || !Files.isReadable(keyFile.toPath())) {
                    throw new IllegalArgumentException("KeyStore file path is unreadable or doesn't exist");
                }
                if (!Files.exists(trustCertificateFile.toPath(), new LinkOption[0]) || !Files.isReadable(trustCertificateFile.toPath())) {
                    throw new IllegalArgumentException("TrustStore file path is unreadable or doesn't exist");
                }
                PrivateKey privateKey = PemReader.loadPrivateKey((File)keyFile, Optional.of(config.getKeyStorePassword()));
                X509Certificate[] certificateChain = PemReader.readCertificateChain((File)keyFile).toArray(new X509Certificate[0]);
                X509Certificate[] trustChain = PemReader.readCertificateChain((File)trustCertificateFile).toArray(new X509Certificate[0]);
                String os = System.getProperty("os.name");
                if (os.toLowerCase(Locale.ENGLISH).contains("linux")) {
                    if (!OpenSsl.isAvailable()) {
                        throw new UnsupportedOperationException(String.format("OpenSsl is not unavailable. Stacktrace: %s", Arrays.toString(OpenSsl.unavailabilityCause().getStackTrace()).replace(',', '\n')));
                    }
                    if (!Epoll.isAvailable()) {
                        throw new UnsupportedOperationException(String.format("Epoll is not unavailable. Stacktrace: %s", Arrays.toString(Epoll.unavailabilityCause().getStackTrace()).replace(',', '\n')));
                    }
                }
                SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provider).protocols(new String[]{"TLSv1.3", "TLSv1.2"}).keyManager(privateKey, certificateChain).trustManager(trustChain).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
                if (config.getCipherSuites().isPresent()) {
                    sslContextBuilder.ciphers((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)config.getCipherSuites().get()));
                }
                sslContext = sslContextBuilder.build();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Failed to configure SSL context", e);
            }
        }
        ConnectionProvider pool = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"shared-pool").maxConnections(config.getMaxConnections())).allocationStrategy((ConnectionProvider.AllocationStrategy)Http2AllocationStrategy.builder().maxConnections(config.getMaxConnections()).maxConcurrentStreams((long)config.getMaxStreamPerChannel()).minConnections(config.getMinConnections()).build())).build();
        LoopResources loopResources = LoopResources.create((String)"event-loop", (int)config.getSelectorThreadCount(), (int)config.getEventLoopThreadCount(), (boolean)true, (boolean)false);
        JmxMeterRegistry jmxMeterRegistry = new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM);
        Metrics.addRegistry((MeterRegistry)jmxMeterRegistry);
        SslContext finalSslContext = sslContext;
        this.httpClient = ((reactor.netty.http.client.HttpClient)((reactor.netty.http.client.HttpClient)reactor.netty.http.client.HttpClient.create((ConnectionProvider)pool).protocol(new HttpProtocol[]{HttpProtocol.H2, HttpProtocol.HTTP11}).runOn(loopResources, true)).http2Settings(settings -> settings.maxConcurrentStreams((long)config.getMaxStreamPerChannel())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)config.getConnectTimeout().getValue()))).metrics(true, () -> new MicrometerChannelMetricsRecorder("reactor.netty.http.client", "tcp", false));
        if (config.isHttpsEnabled()) {
            if (finalSslContext == null) {
                throw new IllegalStateException("SSL context must be configured for HTTPS");
            }
            this.httpClient = this.httpClient.secure(spec -> spec.sslContext(finalSslContext));
        }
        this.requestTimeout = config.getRequestTimeout();
    }

    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        throw new UnsupportedOperationException();
    }

    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request airliftRequest, ResponseHandler<T, E> responseHandler) {
        SettableFuture listenableFuture = SettableFuture.create();
        reactor.netty.http.client.HttpClient client = this.httpClient.headers(hdr -> {
            for (Map.Entry entry : airliftRequest.getHeaders().entries()) {
                hdr.set((String)entry.getKey(), entry.getValue());
            }
        });
        URI uri = airliftRequest.getUri();
        return new HttpClient.HttpResponseFuture(){
            final /* synthetic */ Disposable val$disposable;
            final /* synthetic */ SettableFuture val$listenableFuture;
            {
                this.val$disposable = disposable;
                this.val$listenableFuture = settableFuture;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                this.val$disposable.dispose();
                return this.val$listenableFuture.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return this.val$listenableFuture.isCancelled();
            }

            public boolean isDone() {
                return this.val$listenableFuture.isDone();
            }

            public Object get() throws InterruptedException, ExecutionException {
                return this.val$listenableFuture.get();
            }

            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.val$listenableFuture.get(timeout, unit);
            }

            public void addListener(Runnable listener, Executor executor) {
                this.val$listenableFuture.addListener(listener, executor);
            }

            public String getState() {
                return "";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(ResponseHandler responseHandler, InputStream inputStream, HttpClientResponse response, SettableFuture<Object> listenableFuture) {
        ArrayListMultimap responseHeaders = ArrayListMultimap.create();
        HttpHeaders headers = response.responseHeaders();
        final int status = response.status().code();
        if (status != 200 && status != 204) {
            listenableFuture.setException((Throwable)new RuntimeException("Invalid response status: " + status));
            return;
        }
        long contentLength = 0L;
        for (String name : headers.names()) {
            if (name.equalsIgnoreCase(CONTENT_LENGTH_HEADER_NAME.toString())) {
                String val = headers.get(name);
                contentLength = Integer.parseInt(val);
                responseHeaders.put((Object)CONTENT_LENGTH_HEADER_NAME, (Object)val);
                continue;
            }
            if (name.equalsIgnoreCase(CONTENT_TYPE_HEADER_NAME.toString())) {
                responseHeaders.put((Object)CONTENT_TYPE_HEADER_NAME, (Object)headers.get(name));
                continue;
            }
            responseHeaders.put((Object)HeaderName.of((String)name), (Object)headers.get(name));
        }
        if (!responseHeaders.containsKey((Object)CONTENT_TYPE_HEADER_NAME) || responseHeaders.get((Object)CONTENT_TYPE_HEADER_NAME).size() != 1) {
            listenableFuture.setException((Throwable)new RuntimeException("Expected ContentType header: " + String.valueOf(responseHeaders)));
            return;
        }
        try {
            long finalContentLength = contentLength;
            Object a = responseHandler.handle(null, new Response(){
                final /* synthetic */ ListMultimap val$responseHeaders;
                final /* synthetic */ long val$finalContentLength;
                final /* synthetic */ InputStream val$inputStream;
                {
                    this.val$responseHeaders = listMultimap;
                    this.val$finalContentLength = l;
                    this.val$inputStream = inputStream;
                }

                public int getStatusCode() {
                    return status;
                }

                public ListMultimap<HeaderName, String> getHeaders() {
                    return this.val$responseHeaders;
                }

                public long getBytesRead() {
                    return this.val$finalContentLength;
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$inputStream;
                }
            });
            inputStream.close();
            listenableFuture.set(a);
        }
        catch (Exception e) {
            listenableFuture.setException((Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to close input stream");
            }
        }
    }

    public void onError(SettableFuture<Object> listenableFuture, Throwable t) {
        listenableFuture.setException(t);
    }

    public void onComplete(SettableFuture<Object> listenableFuture) {
        if (!listenableFuture.isDone()) {
            listenableFuture.setException((Throwable)new RuntimeException("completed without success or failure"));
        }
    }

    public RequestStats getStats() {
        return null;
    }

    public long getMaxContentLength() {
        return 0L;
    }

    @Override
    public void close() {
    }

    public boolean isClosed() {
        return false;
    }
}

