/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.spi.QueryId;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;

public class HttpLocationFactory
implements LocationFactory {
    private final InternalNodeManager nodeManager;
    private final URI baseUri;
    private final InternalCommunicationConfig.CommunicationProtocol taskCommunicationProtocol;

    @Inject
    public HttpLocationFactory(InternalNodeManager nodeManager, HttpServerInfo httpServerInfo, InternalCommunicationConfig config) {
        this(nodeManager, config.isHttpsRequired() ? httpServerInfo.getHttpsUri() : httpServerInfo.getHttpUri(), config.getTaskCommunicationProtocol());
    }

    public HttpLocationFactory(InternalNodeManager nodeManager, URI baseUri, InternalCommunicationConfig.CommunicationProtocol taskCommunicationProtocol) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.baseUri = Objects.requireNonNull(baseUri, "baseUri is null");
        this.taskCommunicationProtocol = Objects.requireNonNull(taskCommunicationProtocol, "taskCommunicationProtocol is null");
    }

    public URI createQueryLocation(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("/v1/query").appendPath(queryId.toString()).build();
    }

    public URI createStageLocation(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("v1/stage").appendPath(stageId.toString()).build();
    }

    public URI createLocalTaskLocation(TaskId taskId) {
        return this.createHttpTaskLocation(this.nodeManager.getCurrentNode(), taskId);
    }

    public URI createLegacyTaskLocation(InternalNode node, TaskId taskId) {
        return this.createHttpTaskLocation(node, taskId);
    }

    public URI createTaskLocation(InternalNode node, TaskId taskId) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(taskId, "taskId is null");
        if (this.taskCommunicationProtocol.equals((Object)InternalCommunicationConfig.CommunicationProtocol.HTTP)) {
            return this.createLegacyTaskLocation(node, taskId);
        }
        OptionalInt thriftPort = node.getThriftPort();
        HttpUriBuilder builder = HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri());
        if (this.taskCommunicationProtocol.equals((Object)InternalCommunicationConfig.CommunicationProtocol.THRIFT) && thriftPort.isPresent()) {
            builder.scheme("thrift");
            builder.port(thriftPort.getAsInt());
        }
        return builder.appendPath("/v1/task").appendPath(taskId.toString()).build();
    }

    public URI createMemoryInfoLocation(InternalNode node) {
        Objects.requireNonNull(node, "node is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath("/v1/memory").build();
    }

    private URI createHttpTaskLocation(InternalNode node, TaskId taskId) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(taskId, "taskId is null");
        return HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath("/v1/task").appendPath(taskId.toString()).build();
    }
}

