/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.RetryUrlValidator;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.protocol.ExecutingQueryResponseProvider;
import com.facebook.presto.server.protocol.QueryBlockingRateLimiter;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.tracing.TracerProviderManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Path(value="/")
@RolesAllowed(value={"user"})
public class QueuedStatementResource {
    private static final Logger log = Logger.get(QueuedStatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final DataSize TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private final DispatchManager dispatchManager;
    private final ExecutingQueryResponseProvider executingQueryResponseProvider;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final Map<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final Map<QueryId, Query> retriedQueries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"dispatch-query-purger"));
    private final boolean compressionEnabled;
    private final boolean nestedDataSerializationEnabled;
    private final SqlParserOptions sqlParserOptions;
    private final TracerProviderManager tracerProviderManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final QueryBlockingRateLimiter queryRateLimiter;
    private final RetryUrlValidator retryUrlValidator;

    @Inject
    public QueuedStatementResource(DispatchManager dispatchManager, DispatchExecutor executor, ExecutingQueryResponseProvider executingQueryResponseProvider, SqlParserOptions sqlParserOptions, ServerConfig serverConfig, TracerProviderManager tracerProviderManager, SessionPropertyManager sessionPropertyManager, QueryBlockingRateLimiter queryRateLimiter, RetryUrlValidator retryUrlValidator) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.executingQueryResponseProvider = Objects.requireNonNull(executingQueryResponseProvider, "executingQueryResponseProvider is null");
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.compressionEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isQueryResultsCompressionEnabled();
        this.nestedDataSerializationEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isNestedDataSerializationEnabled();
        this.responseExecutor = Objects.requireNonNull(executor, "responseExecutor is null").getExecutor();
        this.timeoutExecutor = Objects.requireNonNull(executor, "timeoutExecutor is null").getScheduledExecutor();
        this.tracerProviderManager = Objects.requireNonNull(tracerProviderManager, "tracerProviderManager is null");
        this.sessionPropertyManager = sessionPropertyManager;
        this.queryRateLimiter = Objects.requireNonNull(queryRateLimiter, "queryRateLimiter is null");
        this.retryUrlValidator = Objects.requireNonNull(retryUrlValidator, "retryUrlValidator is null");
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                this.purgeQueries(this.queries);
                this.purgeQueries(this.retriedQueries);
            }
            catch (Throwable e) {
                log.error(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Managed
    @Nested
    public TimeStat getRateLimiterBlockTime() {
        return this.queryRateLimiter.getRateLimiterBlockTime();
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Path(value="/v1/statement")
    @Produces(value={"application/json"})
    public Response postStatement(String statement, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @QueryParam(value="retryUrl") String retryUrlString, @QueryParam(value="retryExpirationInSeconds") Long retryExpirationInSeconds, @HeaderParam(value="X-Presto-Retry-Query") String isRetryQueryHeader, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)statement)) {
            throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "SQL statement is empty");
        }
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        boolean isRetryQuery = Boolean.parseBoolean(isRetryQueryHeader);
        Optional<Object> retryUrl = Optional.empty();
        OptionalLong retryExpirationEpochTime = OptionalLong.empty();
        if (retryUrlString != null && !retryUrlString.isEmpty() || retryExpirationInSeconds != null) {
            if (retryUrlString == null || retryUrlString.isEmpty() || retryExpirationInSeconds == null || retryExpirationInSeconds < 1L) {
                throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, String.format("Invalid retry parameters: retryUrl=%s, retryExpiration=%s", retryUrlString, retryExpirationInSeconds));
            }
            retryUrl = Optional.of(QueuedStatementResource.getRetryUrl(retryUrlString));
            retryExpirationEpochTime = OptionalLong.of(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(retryExpirationInSeconds));
            String currentHost = uriInfo.getBaseUri().getHost();
            if (!this.retryUrlValidator.isValidRetryUrl((URI)retryUrl.get(), currentHost)) {
                throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "Invalid retry URL");
            }
        }
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest, this.sqlParserOptions, this.tracerProviderManager.getTracerProvider(), Optional.of(this.sessionPropertyManager), statement);
        QueryId newQueryId = this.dispatchManager.createQueryId();
        Query query = new Query(statement, sessionContext, this.dispatchManager, this.executingQueryResponseProvider, 0, newQueryId, QueuedStatementResource.createSlug(), isRetryQuery, retryUrl, retryExpirationEpochTime);
        this.queries.put(query.getQueryId(), query);
        return QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)query.getInitialQueryResults(uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults)), this.compressionEnabled).cacheControl(query.getDefaultCacheControl()).build();
    }

    private static URI getRetryUrl(String urlEncodedUrl) {
        try {
            String decodedUrl = URLDecoder.decode(urlEncodedUrl, StandardCharsets.UTF_8.toString());
            return URI.create(decodedUrl);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "Retry URL invalid");
        }
    }

    @PUT
    @Path(value="/v1/statement/{queryId}")
    @Produces(value={"application/json"})
    public Response putStatement(String statement, @PathParam(value="queryId") QueryId queryId, @QueryParam(value="slug") String slug, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)statement)) {
            throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "SQL statement is empty");
        }
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest, this.sqlParserOptions, this.tracerProviderManager.getTracerProvider(), Optional.of(this.sessionPropertyManager), statement);
        Query attemptedQuery = new Query(statement, sessionContext, this.dispatchManager, this.executingQueryResponseProvider, 0, queryId, slug);
        Query query = this.queries.computeIfAbsent(queryId, unused -> attemptedQuery);
        if (attemptedQuery != query && !attemptedQuery.getSlug().equals(query.getSlug()) || query.getLastToken() != 0L) {
            throw QueuedStatementResource.badRequest(Response.Status.CONFLICT, "Query already exists");
        }
        return QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)query.getInitialQueryResults(uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults)), this.compressionEnabled).cacheControl(query.getDefaultCacheControl()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/v1/statement/queued/retry/{queryId}")
    @Produces(value={"application/json"})
    public Response retryFailedQuery(@PathParam(value="queryId") QueryId queryId, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context UriInfo uriInfo) {
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        Query failedQuery = this.queries.get(queryId);
        if (failedQuery == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.RETRY_QUERY_NOT_FOUND, "failed to find the query to retry with ID " + String.valueOf(queryId));
        }
        if (this.dispatchManager.isQueryPresent(queryId) && this.dispatchManager.getQueryInfo(queryId).getFailureInfo() == null && !failedQuery.isRetryQuery()) {
            throw QueuedStatementResource.badRequest(Response.Status.CONFLICT, "Query with ID " + String.valueOf(queryId) + " has not failed and cannot be retried");
        }
        int retryCount = failedQuery.getRetryCount() + 1;
        Query query = new Query("-- retry query " + String.valueOf(queryId) + "; attempt: " + retryCount + "\n" + failedQuery.getQuery(), failedQuery.getSessionContext(), this.dispatchManager, this.executingQueryResponseProvider, retryCount);
        this.retriedQueries.putIfAbsent(queryId, query);
        Query query2 = this.retriedQueries.get(queryId);
        synchronized (query2) {
            if (failedQuery.isRetryQuery() && failedQuery.getLastToken() != 0L) {
                throw QueuedStatementResource.badRequest(Response.Status.CONFLICT, "Query with ID " + String.valueOf(queryId) + " has already been processed and cannot be retried");
            }
            if (this.retriedQueries.get(queryId).getQueryId().equals((Object)query.getQueryId())) {
                this.queries.put(query.getQueryId(), query);
            } else {
                query = this.retriedQueries.get(queryId);
            }
        }
        return QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)query.getInitialQueryResults(uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults)), this.compressionEnabled).cacheControl(query.getDefaultCacheControl()).build();
    }

    @GET
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getStatus(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        Query query = this.getQuery(queryId, slug);
        if (query.isRetryQuery()) {
            throw QueuedStatementResource.badRequest(Response.Status.CONFLICT, String.format("Query with ID %s is a retry query and cannot be polled directly. Use /v1/statement/queued/retry/%s endpoint to retry it.", queryId, queryId));
        }
        ListenableFuture acquirePermitAsync = this.queryRateLimiter.acquire(queryId);
        ListenableFuture waitForDispatchedAsync = Futures.transformAsync((ListenableFuture)acquirePermitAsync, acquirePermitTimeSeconds -> {
            this.queryRateLimiter.addRateLimiterBlockTime(new Duration(acquirePermitTimeSeconds.doubleValue(), TimeUnit.SECONDS));
            return query.waitForDispatched();
        }, (Executor)this.responseExecutor);
        ListenableFuture futureStateChange = MoreFutures.addTimeout((ListenableFuture)waitForDispatchedAsync, () -> null, (Duration)((Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait)), (ScheduledExecutorService)this.timeoutExecutor);
        ListenableFuture queryResultsFuture = Futures.transformAsync((ListenableFuture)futureStateChange, ignored -> query.toResponse(token, uriInfo, xForwardedProto, xPrestoPrefixUrl, (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait), this.compressionEnabled, this.nestedDataSerializationEnabled, binaryResults), (Executor)this.responseExecutor);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)queryResultsFuture, (Executor)this.responseExecutor);
    }

    @DELETE
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        this.getQuery(queryId, slug).cancel();
        return Response.noContent().build();
    }

    private Query getQuery(QueryId queryId, String slug) {
        Query query = this.queries.get(queryId);
        if (query == null || !query.getSlug().equals(slug)) {
            throw QueuedStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
        }
        return query;
    }

    private void purgeQueries(Map<QueryId, Query> queries) {
        for (Map.Entry entry : ImmutableSet.copyOf(queries.entrySet())) {
            if (!((Query)entry.getValue()).isSubmissionFinished() || this.dispatchManager.isQueryPresent((QueryId)entry.getKey())) continue;
            queries.remove(entry.getKey());
        }
    }

    private static WebApplicationException badRequest(Response.Status status, String message) {
        throw new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    private static Response.ResponseBuilder withCompressionConfiguration(Response.ResponseBuilder builder, boolean compressionEnabled) {
        if (!compressionEnabled) {
            builder.encoding("identity");
        }
        return builder;
    }

    private static String createSlug() {
        return "x" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
    }

    private static final class Query {
        private static final int CACHE_CONTROL_MAX_AGE_SEC = 60;
        private final String query;
        private final SessionContext sessionContext;
        private final DispatchManager dispatchManager;
        private final ExecutingQueryResponseProvider executingQueryResponseProvider;
        private final QueryId queryId;
        private final String slug;
        private final AtomicLong lastToken = new AtomicLong();
        private final int retryCount;
        private final long expirationTime;
        private final boolean isRetryQuery;
        private final Optional<URI> retryUrl;
        private final OptionalLong retryExpirationEpochTime;
        @GuardedBy(value="this")
        private ListenableFuture<?> querySubmissionFuture;

        public Query(String query, SessionContext sessionContext, DispatchManager dispatchManager, ExecutingQueryResponseProvider executingQueryResponseProvider, int retryCount) {
            this(query, sessionContext, dispatchManager, executingQueryResponseProvider, retryCount, dispatchManager.createQueryId(), Query.createSlug(), false, Optional.empty(), OptionalLong.empty());
        }

        public Query(String query, SessionContext sessionContext, DispatchManager dispatchManager, ExecutingQueryResponseProvider executingQueryResponseProvider, int retryCount, QueryId queryId, String slug) {
            this(query, sessionContext, dispatchManager, executingQueryResponseProvider, retryCount, queryId, slug, false, Optional.empty(), OptionalLong.empty());
        }

        public Query(String query, SessionContext sessionContext, DispatchManager dispatchManager, ExecutingQueryResponseProvider executingQueryResponseProvider, int retryCount, QueryId queryId, String slug, boolean isRetryQuery, Optional<URI> retryUrl, OptionalLong retryExpirationEpochTime) {
            this.query = Objects.requireNonNull(query, "query is null");
            this.sessionContext = Objects.requireNonNull(sessionContext, "sessionContext is null");
            this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
            this.executingQueryResponseProvider = Objects.requireNonNull(executingQueryResponseProvider, "executingQueryResponseProvider is null");
            this.retryCount = retryCount;
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.slug = Objects.requireNonNull(slug, "slug is null");
            this.expirationTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
            this.isRetryQuery = isRetryQuery;
            this.retryUrl = Objects.requireNonNull(retryUrl, "retryUrl is null");
            this.retryExpirationEpochTime = Objects.requireNonNull(retryExpirationEpochTime, "retryExpirationEpochTime is null");
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public String getQuery() {
            return this.query;
        }

        public SessionContext getSessionContext() {
            return this.sessionContext;
        }

        public String getSlug() {
            return this.slug;
        }

        public long getLastToken() {
            return this.lastToken.get();
        }

        public boolean isRetryQuery() {
            return this.isRetryQuery;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public CacheControl getDefaultCacheControl() {
            long maxAgeMillis = Math.max(0L, this.expirationTime - System.currentTimeMillis());
            return CacheControl.valueOf((String)("max-age=" + TimeUnit.MILLISECONDS.toSeconds(maxAgeMillis)));
        }

        public synchronized boolean isSubmissionFinished() {
            return this.querySubmissionFuture != null && this.querySubmissionFuture.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListenableFuture<?> waitForDispatched() {
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null) {
                    this.querySubmissionFuture = this.dispatchManager.createQuery(this.queryId, this.slug, this.retryCount, this.sessionContext, this.query);
                }
                if (!this.querySubmissionFuture.isDone()) {
                    return this.querySubmissionFuture;
                }
            }
            return this.dispatchManager.waitForDispatched(this.queryId);
        }

        public synchronized QueryResults getInitialQueryResults(UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, boolean binaryResults) {
            Verify.verify((this.lastToken.get() == 0L ? 1 : 0) != 0);
            Verify.verify((this.querySubmissionFuture == null ? 1 : 0) != 0);
            return this.createQueryResults(1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, DispatchInfo.waitingForPrerequisites((Duration)QueryResourceUtil.NO_DURATION, (Duration)QueryResourceUtil.NO_DURATION), binaryResults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<Response> toResponse(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, Duration maxWait, boolean compressionEnabled, boolean nestedDataSerializationEnabled, boolean binaryResults) {
            Optional<ListenableFuture<Response>> executingQueryResponse;
            long lastToken = this.lastToken.get();
            if (token != lastToken && token != lastToken + 1L) {
                throw new WebApplicationException(Response.Status.GONE);
            }
            this.lastToken.compareAndSet(lastToken, token);
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null || !this.querySubmissionFuture.isDone()) {
                    QueryResults queryResults = this.createQueryResults(token + 1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, DispatchInfo.waitingForPrerequisites((Duration)QueryResourceUtil.NO_DURATION, (Duration)QueryResourceUtil.NO_DURATION), binaryResults);
                    return Futures.immediateFuture((Object)QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)queryResults), compressionEnabled).cacheControl(this.getDefaultCacheControl()).build());
                }
            }
            Optional dispatchInfo = this.dispatchManager.getDispatchInfo(this.queryId);
            if (!dispatchInfo.isPresent()) {
                return Futures.immediateFailedFuture((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build()));
            }
            long durationUntilExpirationMs = this.dispatchManager.getDurationUntilExpirationInMillis(this.queryId);
            if (this.waitForDispatched().isDone() && (executingQueryResponse = this.executingQueryResponseProvider.waitForExecutingResponse(this.queryId, this.slug, (DispatchInfo)dispatchInfo.get(), uriInfo, xPrestoPrefixUrl, QueryResourceUtil.getScheme(xForwardedProto, uriInfo), maxWait, TARGET_RESULT_SIZE, compressionEnabled, nestedDataSerializationEnabled, binaryResults, durationUntilExpirationMs, this.retryUrl, this.retryExpirationEpochTime, this.isRetryQuery)).isPresent()) {
                return executingQueryResponse.get();
            }
            return Futures.immediateFuture((Object)QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)this.createQueryResults(token + 1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, (DispatchInfo)dispatchInfo.get(), binaryResults)), compressionEnabled).cacheControl(QueryResourceUtil.getCacheControlMaxAge(durationUntilExpirationMs)).build());
        }

        public synchronized void cancel() {
            this.querySubmissionFuture.addListener(() -> this.dispatchManager.cancelQuery(this.queryId), MoreExecutors.directExecutor());
        }

        private QueryResults createQueryResults(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, DispatchInfo dispatchInfo, boolean binaryResults) {
            URI nextUri = this.getNextUri(token, uriInfo, xForwardedProto, xPrestoPrefixUrl, dispatchInfo, binaryResults);
            Optional<QueryError> queryError = dispatchInfo.getFailureInfo().map(this::toQueryError);
            return QueryResourceUtil.createQueuedQueryResults(this.queryId, nextUri, queryError, uriInfo, xForwardedProto, xPrestoPrefixUrl, dispatchInfo.getElapsedTime(), dispatchInfo.getQueuedTime(), dispatchInfo.getWaitingForPrerequisitesTime());
        }

        private static String createSlug() {
            return "x" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        }

        private URI getNextUri(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, DispatchInfo dispatchInfo, boolean binaryResults) {
            if (dispatchInfo.getFailureInfo().isPresent()) {
                return null;
            }
            return QueryResourceUtil.getQueuedUri(this.queryId, this.slug, token, uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults);
        }

        private QueryError toQueryError(ExecutionFailureInfo executionFailureInfo) {
            ErrorCode errorCode;
            if (executionFailureInfo.getErrorCode() != null) {
                errorCode = executionFailureInfo.getErrorCode();
            } else {
                errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
                log.warn("Failed query %s has no error code", new Object[]{this.queryId});
            }
            return new QueryError((String)MoreObjects.firstNonNull((Object)executionFailureInfo.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), errorCode.isRetriable(), executionFailureInfo.getErrorLocation(), executionFailureInfo.toFailureInfo());
        }
    }
}

