/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.server.RetryConfig;
import com.facebook.presto.server.protocol.RetryCircuitBreaker;
import com.facebook.presto.server.protocol.RowIterable;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.QueryInfoUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static Optional<QueryId> originalBeforeRetryQueryId = Optional.empty();
    private static Optional<Integer> previousQueryTopLevelPlanHash = Optional.empty();
    private static Optional<QueryError> previousQueryFailureError = Optional.empty();
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final QueryId queryId;
    private final Session session;
    private final String slug;
    private final Optional<URI> retryUrl;
    private final OptionalLong retryExpirationEpochTime;
    private final boolean isRetryQuery;
    @GuardedBy(value="this")
    private final ExchangeClient exchangeClient;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final PagesSerde serde;
    private final RetryCircuitBreaker retryCircuitBreaker;
    private final RetryConfig retryConfig;
    @GuardedBy(value="this")
    private OptionalLong nextToken = OptionalLong.of(0L);
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private long lastToken = -1L;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setSchema = Optional.empty();
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties = ImmutableSet.of();
    @GuardedBy(value="this")
    private Map<String, SelectedRole> setRoles = ImmutableMap.of();
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements = ImmutableSet.of();
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId = Optional.empty();
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Long updateCount;
    @GuardedBy(value="this")
    private boolean hasProducedResult;
    @GuardedBy(value="this")
    private Map<SqlFunctionId, SqlInvokedFunction> addedSessionFunctions = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<SqlFunctionId> removedSessionFunctions = ImmutableSet.of();

    public static Query create(Session session, String slug, QueryManager queryManager, TransactionManager transactionManager, ExchangeClient exchangeClient, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde, RetryCircuitBreaker retryCircuitBreaker, RetryConfig retryConfig, Optional<URI> retryUrl, OptionalLong retryExpirationEpochTime, boolean isRetryQuery) {
        Query result = new Query(session, slug, retryUrl, retryExpirationEpochTime, isRetryQuery, queryManager, transactionManager, exchangeClient, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde, retryCircuitBreaker, retryConfig);
        result.queryManager.addOutputInfoListener(result.getQueryId(), result::setQueryOutputInfo);
        result.queryManager.addStateChangeListener(result.getQueryId(), state -> {
            if (state.isDone()) {
                QueryInfo queryInfo = queryManager.getFullQueryInfo(result.getQueryId());
                result.closeExchangeClientIfNecessary(queryInfo);
            }
        });
        return result;
    }

    private Query(Session session, String slug, Optional<URI> retryUrl, OptionalLong retryExpirationEpochTime, boolean isRetryQuery, QueryManager queryManager, TransactionManager transactionManager, ExchangeClient exchangeClient, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde, RetryCircuitBreaker retryCircuitBreaker, RetryConfig retryConfig) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(slug, "slug is null");
        Objects.requireNonNull(retryUrl, "retryUrl is null");
        Objects.requireNonNull(retryExpirationEpochTime, "retryExpirationEpochTime is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(exchangeClient, "exchangeClient is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        Objects.requireNonNull(blockEncodingSerde, "serde is null");
        Objects.requireNonNull(retryCircuitBreaker, "retryCircuitBreaker is null");
        Objects.requireNonNull(retryConfig, "retryConfig is null");
        this.queryManager = queryManager;
        this.transactionManager = transactionManager;
        this.queryId = session.getQueryId();
        this.session = session;
        this.slug = slug;
        this.retryUrl = retryUrl;
        this.retryExpirationEpochTime = retryExpirationEpochTime;
        this.isRetryQuery = isRetryQuery;
        this.exchangeClient = exchangeClient;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        this.serde = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.getExchangeCompressionCodec((Session)session), SystemSessionProperties.isExchangeChecksumEnabled((Session)session)).createPagesSerde();
        this.retryCircuitBreaker = retryCircuitBreaker;
        this.retryConfig = retryConfig;
    }

    public void cancel() {
        this.queryManager.cancelQuery(this.queryId);
        this.dispose();
    }

    public synchronized void dispose() {
        this.exchangeClient.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isSlugValid(String slug) {
        return this.slug.equals(slug);
    }

    public Tracer getTracer() {
        Optional tracer = this.session.getTracer();
        Preconditions.checkArgument((boolean)tracer.isPresent(), (Object)"tracer is not present");
        return (Tracer)tracer.get();
    }

    public synchronized Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    public synchronized Optional<String> getSetSchema() {
        return this.setSchema;
    }

    public synchronized Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public synchronized Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public synchronized Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    public synchronized Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public synchronized Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public synchronized Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    public synchronized boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    public synchronized Map<SqlFunctionId, SqlInvokedFunction> getAddedSessionFunctions() {
        return this.addedSessionFunctions;
    }

    public synchronized Set<SqlFunctionId> getRemovedSessionFunctions() {
        return this.removedSessionFunctions;
    }

    public synchronized ListenableFuture<QueryResults> waitForResults(long token, UriInfo uriInfo, String scheme, Duration wait, DataSize targetResultSize, boolean binaryResults) {
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return Futures.immediateFuture((Object)cachedResult.get());
        }
        ListenableFuture futureStateChange = MoreFutures.addTimeout(this.getFutureStateChange(), () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResultWithRetry(token, uriInfo, scheme, targetResultSize, binaryResults), (Executor)this.resultsProcessorExecutor);
    }

    private synchronized ListenableFuture<?> getFutureStateChange() {
        if (!this.exchangeClient.isClosed()) {
            return this.exchangeClient.isBlocked();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        try {
            return this.queryDoneFuture(this.queryManager.getQueryState(this.queryId));
        }
        catch (NoSuchElementException e) {
            return Futures.immediateFuture(null);
        }
    }

    private synchronized Optional<QueryResults> getCachedResult(long token) {
        if (this.lastResult == null) {
            return Optional.empty();
        }
        if (token == this.lastToken) {
            this.queryManager.recordHeartbeat(this.queryId);
            return Optional.of(this.lastResult);
        }
        if (token < this.lastToken) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (!this.nextToken.isPresent()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (token != this.nextToken.getAsLong()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    private synchronized QueryResults getNextResultWithRetry(long token, UriInfo uriInfo, String scheme, DataSize targetResultSize, boolean binaryResults) {
        boolean hasNotRetried;
        QueryResults queryResults = this.getNextResult(token, uriInfo, scheme, targetResultSize, binaryResults);
        if (queryResults.getError() == null) {
            return queryResults;
        }
        boolean historyBasedOptimizationEnabled = SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled((Session)this.session) && SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled((Session)this.session);
        boolean bl = hasNotRetried = this.queryManager.getQueryRetryCount(this.queryId) < 1;
        if (historyBasedOptimizationEnabled && hasNotRetried && this.retryConditionsMet(queryResults) && SystemSessionProperties.retryQueryWithHistoryBasedOptimizationEnabled((Session)this.session)) {
            originalBeforeRetryQueryId = Optional.of(this.queryId);
            previousQueryTopLevelPlanHash = this.getCurrentTopLevelPlanHash();
            previousQueryFailureError = Optional.of(queryResults.getError());
        } else {
            if (this.queryManager.getQueryRetryCount(this.queryId) == 1 && SystemSessionProperties.retryQueryWithHistoryBasedOptimizationEnabled((Session)this.session) && this.retryConditionsMet(queryResults) && historyBasedOptimizationEnabled) {
                Optional<Integer> currentTopLevelPlanHash = this.getCurrentTopLevelPlanHash();
                if (previousQueryTopLevelPlanHash.isPresent() && currentTopLevelPlanHash.isPresent() && currentTopLevelPlanHash.equals(previousQueryTopLevelPlanHash) || !previousQueryTopLevelPlanHash.isPresent() && !currentTopLevelPlanHash.isPresent()) {
                    this.queryManager.failQuery(this.queryId, (Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Since the plan hashes did not change, your retry query will not execute.Your original error was " + String.valueOf(previousQueryFailureError.get()) + ". Original QueryId: " + String.valueOf(originalBeforeRetryQueryId) + ". Retry QueryId: " + String.valueOf(this.queryId)));
                }
                originalBeforeRetryQueryId = Optional.empty();
                previousQueryTopLevelPlanHash = Optional.empty();
                previousQueryFailureError = Optional.empty();
                return queryResults;
            }
            if (!this.retryConditionsMet(queryResults)) {
                return queryResults;
            }
        }
        URI nextUri = this.createRetryUri(scheme, uriInfo);
        return new QueryResults(this.queryId.toString(), queryResults.getInfoUri(), queryResults.getPartialCancelUri(), nextUri, queryResults.getColumns(), null, null, StatementStats.builder().setState(QueryState.WAITING_FOR_PREREQUISITES.toString()).setWaitingForPrerequisites(true).build(), null, (List)ImmutableList.of(), queryResults.getUpdateType(), queryResults.getUpdateCount());
    }

    private synchronized QueryResults getNextResult(long token, UriInfo uriInfo, String scheme, DataSize targetResultSize, boolean binaryResults) {
        Number number;
        Iterator iterator;
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return cachedResult.get();
        }
        Verify.verify((boolean)this.nextToken.isPresent(), (String)"Can not generate next result when next token is not present", (Object[])new Object[0]);
        Verify.verify((token == this.nextToken.getAsLong() ? 1 : 0) != 0, (String)"Expected token to equal next token", (Object[])new Object[0]);
        URI queryHtmlUri = uriInfo.getRequestUriBuilder().scheme(scheme).replacePath("ui/query.html").replaceQuery(this.queryId.toString()).build(new Object[0]);
        Iterable data = null;
        ImmutableList binaryData = null;
        try {
            long rows = 0L;
            long targetResultBytes = targetResultSize.toBytes();
            if (binaryResults) {
                SerializedPage serializedPage;
                ImmutableList.Builder pages = ImmutableList.builder();
                for (bytes = 0L; bytes < targetResultBytes && (serializedPage = this.exchangeClient.pollPage()) != null; bytes += (long)serializedPage.getSizeInBytes()) {
                    rows += (long)serializedPage.getPositionCount();
                    DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
                    PagesSerdeUtil.writeSerializedPage((SliceOutput)sliceOutput, (SerializedPage)serializedPage);
                    String encodedPage = BASE64_ENCODER.encodeToString(sliceOutput.slice().byteArray());
                    pages.add((Object)encodedPage);
                }
                if (rows > 0L) {
                    binaryData = pages.build();
                }
            } else {
                SerializedPage serializedPage;
                ImmutableList.Builder pages = ImmutableList.builder();
                while (bytes < targetResultBytes && (serializedPage = this.exchangeClient.pollPage()) != null) {
                    Page page = this.serde.deserialize(serializedPage);
                    bytes += page.getLogicalSizeInBytes();
                    rows += (long)page.getPositionCount();
                    pages.add((Object)new RowIterable(this.session.toConnectorSession(), this.types, page));
                }
                if (rows > 0L) {
                    data = Iterables.concat((Iterable)pages.build());
                }
            }
            if (rows > 0L) {
                this.hasProducedResult = true;
            }
        }
        catch (Exception e) {
            this.queryManager.failQuery(this.queryId, (Throwable)e);
        }
        QueryInfo queryInfo = this.queryManager.getFullQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)((List)iterator.next()).get(0)) != null) {
            this.updateCount = number.longValue();
        }
        this.closeExchangeClientIfNecessary(queryInfo);
        if (queryInfo.getState() == QueryState.FINISHED && !queryInfo.getOutputStage().isPresent()) {
            this.columns = ImmutableList.of((Object)new Column("result", (Type)BooleanType.BOOLEAN));
            data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
        }
        this.nextToken = !queryInfo.isFinalQueryInfo() && queryInfo.getState() != QueryState.FAILED || !this.exchangeClient.isClosed() ? OptionalLong.of(token + 1L) : OptionalLong.empty();
        URI nextResultsUri = null;
        if (this.nextToken.isPresent()) {
            nextResultsUri = this.createNextResultsUri(scheme, uriInfo, this.nextToken.getAsLong(), binaryResults);
        }
        this.setCatalog = queryInfo.getSetCatalog();
        this.setSchema = queryInfo.getSetSchema();
        this.setSessionProperties = queryInfo.getSetSessionProperties();
        this.resetSessionProperties = queryInfo.getResetSessionProperties();
        this.setRoles = queryInfo.getSetRoles();
        this.addedPreparedStatements = queryInfo.getAddedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.getDeallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.getStartedTransactionId();
        this.clearTransactionId = queryInfo.isClearTransactionId();
        this.addedSessionFunctions = queryInfo.getAddedSessionFunctions();
        this.removedSessionFunctions = queryInfo.getRemovedSessionFunctions();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), queryHtmlUri, Query.findCancelableLeafStage(queryInfo), nextResultsUri, this.columns, data, (Iterable)binaryData, QueryInfoUtils.toStatementStats((QueryInfo)queryInfo), Query.toQueryError(queryInfo), queryInfo.getWarnings(), queryInfo.getUpdateType(), this.updateCount);
        this.lastToken = token;
        this.lastResult = queryResults;
        return queryResults;
    }

    private synchronized void closeExchangeClientIfNecessary(QueryInfo queryInfo) {
        if (queryInfo.getState() == QueryState.FAILED || queryInfo.getState().isDone() && !queryInfo.getOutputStage().isPresent()) {
            this.exchangeClient.close();
        }
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List columnNames = outputInfo.getColumnNames();
            List columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                list.add((Object)new Column((String)columnNames.get(i), (Type)columnTypes.get(i)));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        outputInfo.getBufferLocations().forEach((arg_0, arg_1) -> ((ExchangeClient)this.exchangeClient).addLocation(arg_0, arg_1));
        if (outputInfo.isNoMoreBufferLocations()) {
            this.exchangeClient.noMoreLocations();
        }
    }

    private ListenableFuture<?> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateFuture(null);
        }
        return Futures.transformAsync((ListenableFuture)this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized URI createNextResultsUri(String scheme, UriInfo uriInfo, long nextToken, boolean binaryResults) {
        Optional targetResultSize;
        UriBuilder uri = uriInfo.getBaseUriBuilder().scheme(scheme).replacePath("/v1/statement/executing").path(this.queryId.toString()).path(String.valueOf(nextToken)).replaceQuery("").queryParam("slug", new Object[]{this.slug});
        if (binaryResults) {
            uri.queryParam("binaryResults", new Object[]{"true"});
        }
        if ((targetResultSize = SystemSessionProperties.getTargetResultSize((Session)this.session)).isPresent()) {
            uri = uri.queryParam("targetResultSize", new Object[]{targetResultSize.get()});
        }
        return uri.build(new Object[0]);
    }

    private synchronized URI createRetryUri(String scheme, UriInfo uriInfo) {
        if (this.retryUrl.isPresent()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.retryExpirationEpochTime.getAsLong()) {
                return this.retryUrl.get();
            }
            log.warn("Retry URL for query %s has expired. Current time: %d, Expiration: %d", new Object[]{this.queryId, currentTime, this.retryExpirationEpochTime.getAsLong()});
        }
        UriBuilder uri = uriInfo.getBaseUriBuilder().scheme(scheme).replacePath("/v1/statement/queued/retry").path(this.queryId.toString()).replaceQuery("");
        Optional targetResultSize = SystemSessionProperties.getTargetResultSize((Session)this.session);
        if (targetResultSize.isPresent()) {
            uri = uri.queryParam("targetResultSize", new Object[]{targetResultSize.get()});
        }
        return uri.build(new Object[0]);
    }

    private static URI findCancelableLeafStage(QueryInfo queryInfo) {
        return queryInfo.getOutputStage().map(Query::findCancelableLeafStage).orElse(null);
    }

    private static URI findCancelableLeafStage(StageInfo stage) {
        if (stage.getLatestAttemptExecutionInfo().getState().isDone()) {
            return null;
        }
        for (StageInfo subStage : Lists.reverse((List)stage.getSubStages())) {
            URI leafStage = Query.findCancelableLeafStage(subStage);
            if (leafStage == null) continue;
            return leafStage;
        }
        return stage.getSelf();
    }

    private boolean retryConditionsMet(QueryResults queryResults) {
        if (queryResults.getError() == null) {
            return false;
        }
        if (!SystemSessionProperties.retryQueryWithHistoryBasedOptimizationEnabled((Session)this.session)) {
            if (this.retryUrl.isPresent()) {
                if (this.isRetryQuery) {
                    log.debug("Query %s is already a retry query, preventing cross-cluster retry chain", new Object[]{this.queryId});
                    return false;
                }
                int errorCode = queryResults.getError().getErrorCode();
                if (!this.retryConfig.getCrossClusterRetryErrorCodes().contains(errorCode)) {
                    log.debug("Query %s error code %d is not allowed for cross-cluster retry. Allowed codes: %s", new Object[]{this.queryId, errorCode, this.retryConfig.getCrossClusterRetryErrorCodes()});
                    return false;
                }
            } else if (!queryResults.getError().isRetriable()) {
                log.debug("Query %s error code %s is not retriable", new Object[]{this.queryId, queryResults.getError().getErrorName()});
                return false;
            }
            this.retryCircuitBreaker.incrementFailure();
            if (!this.retryCircuitBreaker.isRetryAllowed()) {
                return false;
            }
            if (this.queryManager.getQueryRetryCount(this.queryId) >= SystemSessionProperties.getQueryRetryLimit((Session)this.session)) {
                return false;
            }
        }
        if (this.hasProducedResult) {
            return false;
        }
        if (this.queryManager.getQueryInfo(this.queryId).getQueryStats().getExecutionTime().toMillis() > SystemSessionProperties.getQueryRetryMaxExecutionTime((Session)this.session).toMillis()) {
            return false;
        }
        return !this.session.getTransactionId().isPresent() || this.transactionManager.getOptionalTransactionInfo(this.session.getRequiredTransactionId()).map(TransactionInfo::isAutoCommitContext).orElse(true) != false;
    }

    private Optional<Integer> getCurrentTopLevelPlanHash() {
        if (this.queryManager.getFullQueryInfo(this.queryId).getPlanCanonicalInfo().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((CanonicalPlanWithInfo)this.queryManager.getFullQueryInfo(this.queryId).getPlanCanonicalInfo().get(0)).getCanonicalPlan().getPlan().hashCode());
    }

    private static QueryError toQueryError(QueryInfo queryInfo) {
        ErrorCode errorCode;
        FailureInfo failure;
        QueryState state = queryInfo.getState();
        if (state != QueryState.FAILED) {
            return null;
        }
        if (queryInfo.getFailureInfo() != null) {
            failure = queryInfo.getFailureInfo().toFailureInfo();
        } else {
            log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
            failure = Failures.toFailure((Throwable)new RuntimeException(String.format("Query is %s (reason unknown)", state))).toFailureInfo();
        }
        if (queryInfo.getErrorCode() != null) {
            errorCode = queryInfo.getErrorCode();
        } else {
            errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
            log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
        }
        return new QueryError((String)MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), errorCode.isRetriable(), failure.getErrorLocation(), failure);
    }
}

