/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.RetryConfig;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.server.protocol.RetryCircuitBreaker;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.transaction.TransactionManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LocalQueryProvider {
    private static final Logger log = Logger.get(LocalQueryProvider.class);
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final RetryCircuitBreaker retryCircuitBreaker;
    private final RetryConfig retryConfig;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"execution-query-purger"));

    @Inject
    public LocalQueryProvider(QueryManager queryManager, TransactionManager transactionManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor, RetryCircuitBreaker retryCircuitBreaker, RetryConfig retryConfig) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.retryCircuitBreaker = Objects.requireNonNull(retryCircuitBreaker, "retryCircuitBreaker is null");
        this.retryConfig = Objects.requireNonNull(retryConfig, "retryConfig is null");
    }

    @PostConstruct
    public void start() {
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                for (Map.Entry entry : this.queries.entrySet()) {
                    try {
                        this.queryManager.getQueryState((QueryId)entry.getKey());
                    }
                    catch (NoSuchElementException e) {
                        this.queries.remove(entry.getKey());
                    }
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    public Query getQuery(QueryId queryId, String slug) {
        return this.getQuery(queryId, slug, Optional.empty(), OptionalLong.empty(), false);
    }

    public Query getQuery(QueryId queryId, String slug, Optional<URI> retryUrl, OptionalLong retryExpirationEpochTime) {
        return this.getQuery(queryId, slug, retryUrl, retryExpirationEpochTime, false);
    }

    public Query getQuery(QueryId queryId, String slug, Optional<URI> retryUrl, OptionalLong retryExpirationEpochTime, boolean isRetryQuery) {
        Session session;
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            return query;
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            session = this.queryManager.getQuerySession(queryId);
        }
        catch (NoSuchElementException e) {
            throw LocalQueryProvider.notFound("Query not found");
        }
        query = this.queries.computeIfAbsent(queryId, id -> {
            ExchangeClient exchangeClient = this.exchangeClientSupplier.get((LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), LocalQueryProvider.class.getSimpleName()));
            return Query.create(session, slug, this.queryManager, this.transactionManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde, this.retryCircuitBreaker, this.retryConfig, retryUrl, retryExpirationEpochTime, isRetryQuery);
        });
        return query;
    }

    public void cancel(QueryId queryId, String slug) {
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            query.cancel();
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw LocalQueryProvider.notFound("Query not found");
            }
            this.queryManager.cancelQuery(queryId);
        }
        catch (NoSuchElementException e) {
            throw LocalQueryProvider.notFound("Query not found");
        }
    }

    private static WebApplicationException notFound(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }
}

