/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.protocol.LocalQueryProvider;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.server.protocol.QueryBlockingRateLimiter;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Path(value="/")
@RolesAllowed(value={"user"})
public class ExecutingStatementResource {
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final DataSize DEFAULT_TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_TARGET_RESULT_SIZE = new DataSize(128.0, DataSize.Unit.MEGABYTE);
    private final BoundedExecutor responseExecutor;
    private final LocalQueryProvider queryProvider;
    private final QueryManager queryManager;
    private final boolean compressionEnabled;
    private final boolean nestedDataSerializationEnabled;
    private final QueryBlockingRateLimiter queryRateLimiter;

    @Inject
    public ExecutingStatementResource(@ForStatementResource BoundedExecutor responseExecutor, LocalQueryProvider queryProvider, QueryManager queryManager, ServerConfig serverConfig, QueryBlockingRateLimiter queryRateLimiter) {
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.queryProvider = Objects.requireNonNull(queryProvider, "queryProvider is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.compressionEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isQueryResultsCompressionEnabled();
        this.nestedDataSerializationEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isNestedDataSerializationEnabled();
        this.queryRateLimiter = Objects.requireNonNull(queryRateLimiter, "queryRateLimiter is null");
    }

    @Managed
    @Nested
    public TimeStat getRateLimiterBlockTime() {
        return this.queryRateLimiter.getRateLimiterBlockTime();
    }

    @GET
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @QueryParam(value="targetResultSize") DataSize targetResultSize, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String proto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        targetResultSize = targetResultSize == null ? DEFAULT_TARGET_RESULT_SIZE : (DataSize)Ordering.natural().min((Object)targetResultSize, (Object)MAX_TARGET_RESULT_SIZE);
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        Query query = this.queryProvider.getQuery(queryId, slug);
        ListenableFuture acquirePermitAsync = this.queryRateLimiter.acquire(queryId);
        String effectiveFinalProto = proto;
        DataSize effectiveFinalTargetResultSize = targetResultSize;
        ListenableFuture waitForResultsAsync = Futures.transformAsync((ListenableFuture)acquirePermitAsync, acquirePermitTimeSeconds -> {
            this.queryRateLimiter.addRateLimiterBlockTime(new Duration(acquirePermitTimeSeconds.doubleValue(), TimeUnit.SECONDS));
            return query.waitForResults(token, uriInfo, effectiveFinalProto, wait, effectiveFinalTargetResultSize, binaryResults);
        }, (Executor)this.responseExecutor);
        long durationUntilExpirationMs = this.queryManager.getDurationUntilExpirationInMillis(queryId);
        ListenableFuture queryResultsFuture = Futures.transform((ListenableFuture)waitForResultsAsync, results -> QueryResourceUtil.toResponse(query, results, xPrestoPrefixUrl, this.compressionEnabled, this.nestedDataSerializationEnabled, durationUntilExpirationMs), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)queryResultsFuture, (Executor)this.responseExecutor);
    }

    @DELETE
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        this.queryProvider.cancel(queryId, slug);
        return Response.noContent().build();
    }
}

