/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.security.oauth2.OAuth2Utils;
import com.facebook.presto.server.security.oauth2.OAuthWebUiCookie;
import com.google.common.base.Strings;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Optional;

@Path(value="/")
@RolesAllowed(value={"admin"})
public class WebUiResource {
    public static final String UI_ENDPOINT = "/";

    @GET
    public Response redirectIndexHtml(@HeaderParam(value="X-Forwarded-Proto") String proto, @Context UriInfo uriInfo) {
        Optional<String> lastURL;
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        if ((lastURL = OAuth2Utils.getLastURLParameter((MultivaluedMap<String, String>)uriInfo.getQueryParameters())).isPresent()) {
            return Response.seeOther((URI)uriInfo.getRequestUriBuilder().scheme(proto).uri(lastURL.get()).build(new Object[0])).build();
        }
        return Response.temporaryRedirect((URI)uriInfo.getRequestUriBuilder().scheme(proto).path("/ui/").replaceQuery("").build(new Object[0])).build();
    }

    @GET
    @Path(value="/logout")
    public Response logout(@HeaderParam(value="X-Forwarded-Proto") String proto, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        return Response.temporaryRedirect((URI)uriInfo.getBaseUriBuilder().scheme(proto).path("/ui/logout.html").build(new Object[0])).cookie(new NewCookie[]{OAuthWebUiCookie.delete()}).build();
    }
}

