/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Comparator;
import java.util.List;

@Path(value="/")
@RolesAllowed(value={"admin"})
public class ThreadResource {
    @GET
    @Path(value="/v1/thread")
    @Produces(value={"application/json"})
    public List<Info> getThreadInfo() {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ThreadInfo info : mbean.getThreadInfo(mbean.getAllThreadIds(), Integer.MAX_VALUE)) {
            if (info == null) continue;
            builder.add((Object)new Info(info.getThreadId(), info.getThreadName(), info.getThreadState().name(), info.getLockOwnerId() == -1L ? null : Long.valueOf(info.getLockOwnerId()), ThreadResource.toStackTrace(info.getStackTrace())));
        }
        return Ordering.from(Info.byName()).sortedCopy((Iterable)builder.build());
    }

    private static List<StackLine> toStackTrace(StackTraceElement[] stackTrace) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StackTraceElement item : stackTrace) {
            builder.add((Object)new StackLine(item.getFileName(), item.getLineNumber(), item.getClassName(), item.getMethodName()));
        }
        return builder.build();
    }

    @ThriftStruct
    public static class Info {
        private final long id;
        private final String name;
        private final String state;
        private final Long lockOwnerId;
        private final List<StackLine> stackTrace;

        @ThriftConstructor
        @JsonCreator
        public Info(@JsonProperty(value="id") long id, @JsonProperty(value="name") String name, @JsonProperty(value="state") String state, @JsonProperty(value="lockOwnerId") Long lockOwnerId, @JsonProperty(value="stackTrace") List<StackLine> stackTrace) {
            this.id = id;
            this.name = name;
            this.state = state;
            this.lockOwnerId = lockOwnerId;
            this.stackTrace = stackTrace;
        }

        @ThriftField(value=1)
        @JsonProperty
        public long getId() {
            return this.id;
        }

        @ThriftField(value=2)
        @JsonProperty
        public String getName() {
            return this.name;
        }

        @ThriftField(value=3)
        @JsonProperty
        public String getState() {
            return this.state;
        }

        @ThriftField(value=4)
        @JsonProperty
        public Long getLockOwnerId() {
            return this.lockOwnerId;
        }

        @ThriftField(value=5)
        @JsonProperty
        public List<StackLine> getStackTrace() {
            return this.stackTrace;
        }

        public static Comparator<Info> byName() {
            return new Comparator<Info>(){

                @Override
                public int compare(Info info, Info info2) {
                    return info.getName().compareTo(info2.getName());
                }
            };
        }
    }

    @ThriftStruct
    public static class StackLine {
        private final String file;
        private final int line;
        private final String className;
        private final String method;

        @ThriftConstructor
        @JsonCreator
        public StackLine(@JsonProperty(value="file") String file, @JsonProperty(value="line") int line, @JsonProperty(value="className") String className, @JsonProperty(value="method") String method) {
            this.file = file;
            this.line = line;
            this.className = className;
            this.method = method;
        }

        @ThriftField(value=1)
        @JsonProperty
        public String getFile() {
            return this.file;
        }

        @ThriftField(value=2)
        @JsonProperty
        public int getLine() {
            return this.line;
        }

        @ThriftField(value=3)
        @JsonProperty
        public String getClassName() {
            return this.className;
        }

        @ThriftField(value=4)
        @JsonProperty
        public String getMethod() {
            return this.method;
        }
    }
}

