/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;

@Path(value="v1/taskInfo")
@RolesAllowed(value={"ADMIN"})
public class TaskInfoResource {
    public static final String INCLUDE_LOCAL_QUERY_ONLY = "includeLocalQueryOnly";
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;
    private final boolean resourceManagerEnabled;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;

    @Inject
    public TaskInfoResource(DispatchManager dispatchManager, QueryManager queryManager, InternalNodeManager internalNodeManager, ServerConfig serverConfig, Optional<ResourceManagerProxy> proxyHelper) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public void getTaskInfo(@PathParam(value="taskId") TaskId taskId, @QueryParam(value="includeLocalQueryOnly") @DefaultValue(value="false") boolean includeLocalQueryOnly, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) throws WebApplicationException {
        if (this.requestNeedsToBeProxied(taskId, includeLocalQueryOnly)) {
            this.proxyTaskInfo(servletRequest, asyncResponse, uriInfo);
        } else {
            try {
                asyncResponse.resume((Object)Response.ok((Object)this.getTaskInfo(taskId)).build());
            }
            catch (NotFoundException e) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find the requested taskInfo").build());
            }
            catch (Exception e) {
                asyncResponse.resume((Object)Response.serverError().entity((Object)e.getMessage()).build());
            }
        }
    }

    private TaskInfo getTaskInfo(TaskId taskId) {
        QueryId queryId = taskId.getQueryId();
        try {
            Optional<TaskInfo> taskInfo;
            Optional stage;
            Optional stageInfo = this.queryManager.getFullQueryInfo(queryId).getOutputStage();
            if (stageInfo.isPresent() && (stage = ((StageInfo)stageInfo.get()).getStageWithStageId(taskId.getStageExecutionId().getStageId())).isPresent() && (taskInfo = ((StageInfo)stage.get()).getLatestAttemptExecutionInfo().getTasks().stream().filter(info -> info.getTaskId().equals((Object)taskId)).findFirst()).isPresent()) {
                return taskInfo.get();
            }
            throw new NotFoundException("TaskInfo not found for task id " + taskId.toString());
        }
        catch (Exception e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    private boolean requestNeedsToBeProxied(TaskId taskId, boolean includeLocalQueryOnly) {
        return !includeLocalQueryOnly && this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(taskId.getQueryId());
    }

    private URI createTaskInfoUri(UriInfo uriInfo, InternalNode resourceManagerNode) throws UnknownHostException {
        return UriBuilder.fromUri((URI)uriInfo.getRequestUri()).queryParam(INCLUDE_LOCAL_QUERY_ONLY, new Object[]{true}).scheme(resourceManagerNode.getInternalUri().getScheme()).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
    }

    private void proxyTaskInfo(HttpServletRequest servletRequest, AsyncResponse asyncResponse, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Optional resourceManager = this.internalNodeManager.getResourceManagers().stream().findAny();
            if (resourceManager.isPresent()) {
                InternalNode resourceManagerNode = (InternalNode)resourceManager.get();
                URI uri = this.createTaskInfoUri(uriInfo, resourceManagerNode);
                this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
            } else {
                asyncResponse.resume((Object)Response.serverError().entity((Object)"Could not find the resource manager").build());
            }
        }
        catch (Exception e) {
            asyncResponse.resume((Object)Response.serverError().entity((Object)e.getMessage()).build());
        }
    }
}

